## Konvertieren einer Single-PSN-Domäne in eine Multi-PSN-Domäne

Stand: 2025-09-25
Autor: Ronny Schuldt

Dieser Vorgang geschieht auf eigenes **Risiko** und es sollte vorher **unbedingt ein Backup der Daten** angelegt werden. Außerdem muss während der Konvertierung der gPAS heruntergefahren werden, um Kompromittierungen oder andere Störungen auf der Datenbank zu vermeiden. 
Seien Sie sich sicher, in dem was Sie tun, es gibt derzeit keine Möglichkeit diesen Vorgang rückgängig zu machen.

1. Fahren Sie den gPAS Application Server (Wildfly) herunter. Der Datenbank-Service bleibt weiterhin online:

    ```
    cd /path/to/compose-wildfly/
    docker compose stop gpas-wildfly
    ```
2. Verbinden Sie sich mit einem DB-Client Ihrer Wahl mit der gPAS-Datenbank und führen folgende Befehle aus. Ersetzen Sie dabei den Platzhalter der **Ziel-Domäne** `single_psn` durch den individuellen Namen der Domäne, die Sie konvertieren möchten.:

    ```sql
    USE gpas;
    CALL convert_to_multi_psn_domain('single_psn');
    ```
3. Starten Sie den gPAS Application Server (Wildfly) wieder:

    ```
    cd /path/to/compose-wildfly/
    docker compose start gpas-wildfly
    ```