ALTER TABLE `domain`
    CHANGE COLUMN `PROPERTIES` `CONFIG` text NOT NULL
;

CREATE TABLE qc_problem
(
    `TYPE`              VARCHAR(100) NOT NULL,
    `REF`               VARCHAR(100) NOT NULL DEFAULT '',
    `STATUS`            VARCHAR(100) NULL,
    `FORM_VALUE`        VARCHAR(4095) NULL,
    `SCAN_VALUE`        VARCHAR(4095) NULL,
    `COMMENT_EXTERN`    VARCHAR(4095) NULL,
    `COMMENT_INTERN`    VARCHAR(4095) NULL,
    `CT_DOMAIN_NAME`    VARCHAR(50) NOT NULL,
    `CT_NAME`           VARCHAR(100) NOT NULL,
    `CT_VERSION`        INT(11) NOT NULL,
    `CONSENT_DATE`      TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `VIRTUAL_PERSON_ID` BIGINT(20) NOT NULL,
    `CREATE_TIMESTAMP`  TIMESTAMP(3)  DEFAULT CURRENT_TIMESTAMP(3),
    `UPDATE_TIMESTAMP`  TIMESTAMP(3)  DEFAULT CURRENT_TIMESTAMP(3),
    `FHIR_ID`           VARCHAR(41) NOT NULL DEFAULT '',
    PRIMARY KEY (`CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`, `CONSENT_DATE`, `VIRTUAL_PERSON_ID`, `TYPE`, `REF`) USING BTREE,
    INDEX I_qc_problem_qc (`CONSENT_DATE`, `VIRTUAL_PERSON_ID`, `CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`) USING BTREE
) collate utf8_bin
;

ALTER TABLE qc_problem
ADD CONSTRAINT FK_qc_problem_qc
FOREIGN KEY
(
    CONSENT_DATE,
    VIRTUAL_PERSON_ID,
    CT_DOMAIN_NAME,
    CT_NAME,
    CT_VERSION
)
REFERENCES qc
(
    CONSENT_DATE,
    VIRTUAL_PERSON_ID,
    CT_DOMAIN_NAME,
    CT_NAME,
    CT_VERSION
) ON UPDATE CASCADE ON DELETE CASCADE
;

CREATE TABLE qc_problem_hist
(
    `TYPE`              VARCHAR(100) NOT NULL,
    `REF`               VARCHAR(100) NOT NULL DEFAULT '',
    `STATUS`            VARCHAR(100) NULL,
    `FORM_VALUE`        VARCHAR(4095) NULL,
    `SCAN_VALUE`        VARCHAR(4095) NULL,
    `COMMENT_EXTERN`    VARCHAR(4095) NULL,
    `COMMENT_INTERN`    VARCHAR(4095) NULL,
    `CT_DOMAIN_NAME`    VARCHAR(50) NOT NULL,
    `CT_NAME`           VARCHAR(100) NOT NULL,
    `CT_VERSION`        INT(11) NOT NULL,
    `CONSENT_DATE`      TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `VIRTUAL_PERSON_ID` BIGINT(20) NOT NULL,
    `CREATE_TIMESTAMP`  TIMESTAMP(3)  DEFAULT CURRENT_TIMESTAMP(3),
    `UPDATE_TIMESTAMP`  TIMESTAMP(3)  DEFAULT CURRENT_TIMESTAMP(3),
    `START_DATE`        TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `END_DATE`          TIMESTAMP(3) NULL DEFAULT NULL,
    `FHIR_ID`           VARCHAR(41) NOT NULL DEFAULT '',
    PRIMARY KEY (`CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`, `CONSENT_DATE`, `VIRTUAL_PERSON_ID`, `TYPE`, `REF`, `START_DATE`) USING BTREE,
    INDEX I_qc_problem_hist_qc (`CONSENT_DATE`, `VIRTUAL_PERSON_ID`, `CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`) USING BTREE
) collate utf8_bin
;

ALTER TABLE qc_problem_hist
ADD CONSTRAINT FK_qc_problem_hist_qc
FOREIGN KEY
(
    CONSENT_DATE,
    VIRTUAL_PERSON_ID,
    CT_DOMAIN_NAME,
    CT_NAME,
    CT_VERSION
)
REFERENCES qc
(
    CONSENT_DATE,
    VIRTUAL_PERSON_ID,
    CT_DOMAIN_NAME,
    CT_NAME,
    CT_VERSION
) ON UPDATE CASCADE ON DELETE CASCADE
;
