-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server-Version:               8.0.30 - MySQL Community Server - GPL
-- Server-Betriebssystem:        Win64
-- HeidiSQL Version:             12.11.0.7065
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Exportiere Datenbank-Struktur für gics
CREATE DATABASE IF NOT EXISTS `gics` /*!40100 DEFAULT CHARACTER SET utf8mb3 COLLATE utf8mb3_bin */ /*!80016 DEFAULT ENCRYPTION='N' */;
USE `gics`;

-- Exportiere Daten aus Tabelle gics.alias: ~0 rows (ungefähr)

-- Exportiere Daten aus Tabelle gics.consent: ~12 rows (ungefähr)
INSERT IGNORE INTO `consent` (`CONSENT_DATE`, `VIRTUAL_PERSON_ID`, `CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`, `COMMENT`, `EXTERN_PROPERTIES`, `EXPIRATION_PROPERTIES`, `CREATE_TIMESTAMP`, `UPDATE_TIMESTAMP`, `VALID_FROM`, `FHIR_ID`) VALUES
	('2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, NULL, NULL, '', '2022-02-01 09:16:49.182', '2022-02-01 09:18:28.053', NULL, '176a83af-8d11-42ac-bc46-05eac6c2f8a6'),
	('2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, NULL, NULL, '', '2022-02-01 09:17:38.248', '2022-02-01 09:18:11.144', NULL, '400a1f46-a438-4696-a7e5-ff7c6680f404'),
	('2022-02-01 09:19:30.733', 1, 'Demo Deutschland', 'Widerruf Datenerhebung', 1000, NULL, NULL, '', '2022-02-01 09:19:30.761', '2022-02-01 09:19:48.555', NULL, '31381d48-3edd-4d57-9876-bc2cc9870941'),
	('2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, NULL, NULL, '', '2022-02-01 09:21:16.360', '2022-02-01 09:21:16.360', NULL, '465c9bf8-6e13-4928-8d75-31e7c0dd5841'),
	('2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, NULL, NULL, '', '2022-02-01 09:22:33.395', '2022-02-01 09:22:33.395', NULL, '38959643-b4c9-4d2e-b57a-c3b20b9fcd9a'),
	('2022-02-01 09:23:23.758', 3, 'Demo EU', 'Withdrawal Data Collection', 1000, NULL, NULL, '', '2022-02-01 09:23:23.768', '2022-02-01 09:23:23.768', NULL, '06a0f273-d00b-452f-bad0-b28772b31957'),
	('2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, NULL, NULL, '', '2022-02-01 09:27:24.174', '2022-02-01 09:27:59.820', NULL, '8727e0ae-b83e-4a56-b799-1007a7e8db31'),
	('2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, NULL, NULL, '', '2022-02-01 09:30:19.387', '2022-02-01 09:30:19.387', NULL, 'e156f408-984e-4147-8e76-ac368fe93eaa'),
	('2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, NULL, NULL, '', '2022-02-01 09:31:40.655', '2022-02-01 09:31:40.655', NULL, '8d18914a-bd17-467f-8eda-71bd6dddfd5c'),
	('2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, NULL, NULL, '', '2022-02-01 09:32:36.489', '2022-02-01 09:33:54.524', NULL, '661af18a-7144-4ee1-a5ab-cb146c6bca32'),
	('2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, NULL, NULL, '', '2022-02-01 09:33:28.639', '2022-02-01 09:34:13.220', NULL, '109cc986-6ee7-4e60-b524-37419564b11d'),
	('2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, NULL, NULL, '', '2022-02-01 09:55:08.246', '2022-02-01 09:55:08.246', NULL, '0a2bec9b-423c-406f-8e7a-20a1e8064e34');

-- Exportiere Daten aus Tabelle gics.consent_scan: ~3 rows (ungefähr)
INSERT IGNORE INTO `consent_scan` (`SCANBASE64`, `FILETYPE`, `FHIR_ID`, `CONSENT_DATE`, `VIRTUAL_PERSON_ID`, `CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`, `FILENAME`, `UPLOAD_DATE`) VALUES
	('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', 'application/pdf', '0c1bc086-a64e-43e6-86d0-3599c56a069b', '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'Demo.pdf', '2022-02-01 09:33:28.638'),
	('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', 'application/pdf', '837b26ba-11a5-4d6b-908d-3e561d459cde', '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'Demo.pdf', '2022-02-01 09:27:24.173'),
	('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', 'application/pdf', '98c2aead-e156-42dc-9203-d352fcd41413', '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'Demo.pdf', '2022-02-01 09:32:36.488');

-- Exportiere Daten aus Tabelle gics.consent_template: ~7 rows (ungefähr)
INSERT IGNORE INTO `consent_template` (`TITLE`, `COMMENT`, `EXTERN_PROPERTIES`, `EXPIRATION_PROPERTIES`, `NAME`, `VERSION`, `DOMAIN_NAME`, `TYPE`, `FOOTER`, `HEADER`, `SCAN`, `CREATE_TIMESTAMP`, `UPDATE_TIMESTAMP`, `LABEL`, `VERSION_LABEL`, `STATE`, `FHIR_ID`, `VALID_FROM_PROPERTIES`) VALUES
	('Demo EU_###_Consent Demostudy_###_1000_###_TEMPLATE_TITLE', '', '', '', 'Consent Demostudy', 1000, 'Demo EU', 'CONSENT', 'Demo EU_###_Consent Demostudy_###_1000_###_FOOTER', 'Demo EU_###_Consent Demostudy_###_1000_###_HEADER', 'Demo EU_###_Consent Demostudy_###_1000', '2022-02-01 09:15:40.703', '2022-02-01 09:20:22.665', 'Consent Demostudy', NULL, 1, '973f02d7-ae33-40aa-8ad9-cb61b2e9207c', NULL),
	('Demo Deutschland_###_Einwilligung Demostudie_###_1000_###_TEMPLATE_TITLE', '', 'orderNr=1;study=demo;', '', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'CONSENT', 'Demo Deutschland_###_Einwilligung Demostudie_###_1000_###_FOOTER', 'Demo Deutschland_###_Einwilligung Demostudie_###_1000_###_HEADER', 'Demo Deutschland_###_Einwilligung Demostudie_###_1000', '2022-02-01 09:15:26.386', '2022-02-01 09:16:12.569', 'Einwilligung Demostudie', NULL, 1, '1723a970-645e-45c2-9c66-97e82a19d862', NULL),
	('MII_###_Patienteneinwilligung MII_###_1006003_###_TEMPLATE_TITLE', 'Aktualisiert am 2025-02-02, Ergänzung MII KDS Consent fhir properties, Version 1.6d der MII Vorlage (April 2020)', 'study=mii;optional=false;orderNr=1;fhirPolicyValueSet=urn:oid:2.16.840.1.113883.3.1937.777.24.5.3;fhirAnswerCodeSystem=2.16.840.1.113883.3.1937.777.24.5.2;fhirAnswerValueSet=https://www.medizininformatik-initiative.de/fhir/ValueSet/MiiConsentAnswerValueSet;fhirAnswerCodeYes=2.16.840.1.113883.3.1937.777.24.5.2.1;fhirAnswerCodeNo=2.16.840.1.113883.3.1937.777.24.5.2.2;fhirAnswerCodeUnknown=2.16.840.1.113883.3.1937.777.24.5.2.3;fhirAnswerDisplayYes=gültig;fhirAnswerDisplayNo=ungültig;fhirAnswerDisplayUnknown=unbekannt;fhirPolicyUri=urn:oid:2.16.840.1.113883.3.1937.777.24.2.1790;fhirConsentCategory=2.16.840.1.113883.3.1937.777.24.2.184', 'VALIDITY_PERIOD=P30Y;', 'Patienteneinwilligung MII', 1006003, 'MII', 'CONSENT', 'MII_###_Patienteneinwilligung MII_###_1006003_###_FOOTER', 'MII_###_Patienteneinwilligung MII_###_1006003_###_HEADER', 'MII_###_Patienteneinwilligung MII_###_1006003', '2022-02-01 09:13:28.517', '2023-05-07 10:49:16.105', 'Patienteneinwilligung MII', '1.6.d', 1, 'd7dc3bc7-36d2-4a57-a9b6-17d415cde184', NULL),
	('MII_###_Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_TEMPLATE_TITLE', 'aktualisiert am 2025-02-02, Umsetzung des MII Mustertext Widerrufsformular „Teil-Widerruf“ OHNE Z-MODUL (Stand 25_01_2021) wie vorgestellt in AG Consent als Gegenstück für MII BroadConsent 1.6.d inkl TFCU Policies v.1.0 im ArtDecor', 'study=mii;optional=false;orderNr=1;fhirPolicyValueSet=urn:oid:2.16.840.1.113883.3.1937.777.24.5.3;fhirAnswerCodeSystem=2.16.840.1.113883.3.1937.777.24.5.2;fhirAnswerValueSet=https://www.medizininformatik-initiative.de/fhir/ValueSet/MiiConsentAnswerValueSet;fhirAnswerCodeYes=2.16.840.1.113883.3.1937.777.24.5.2.1;fhirPolicyUri=urn:oid:2.16.840.1.113883.3.1937.777.24.2.2719;fhirConsentCategory=2.16.840.1.113883.3.1937.777.24.2.184;fhirAnswerCodeNo=2.16.840.1.113883.3.1937.777.24.5.2.2;fhirAnswerCodeUnknown=2.16.840.1.113883.3.1937.777.24.5.2.3;fhirAnswerDisplayYes=gültig;fhirAnswerDisplayNo=ungültig;fhirAnswerDisplayUnknown=unbekannt', '', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'REVOCATION', 'MII_###_Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_FOOTER', 'MII_###_Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_HEADER', 'MII_###_Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000', '2022-02-01 09:13:43.497', '2022-02-01 12:02:59.823', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', '2.0', 1, '68274654-84e4-437e-8e1b-5cdbf441547e', NULL),
	('MII_###_Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_TEMPLATE_TITLE', 'aktualisiert am 2025-02-02, Umsetzung des MII Mustertext Widerrufsformular „Vollständiger Widerruf“ OHNE Z-MODUL (Stand 25_01_2021) wie vorgestellt in AG Consent als Gegenstück für MII BroadConsent 1.6.d inkl TFCU Policies v.1.0 im ArtDecor', 'study=mii;optional=false;orderNr=1;fhirPolicyValueSet=urn:oid:2.16.840.1.113883.3.1937.777.24.5.3;fhirAnswerCodeSystem=2.16.840.1.113883.3.1937.777.24.5.2;fhirAnswerValueSet=https://www.medizininformatik-initiative.de/fhir/ValueSet/MiiConsentAnswerValueSet;fhirAnswerCodeYes=2.16.840.1.113883.3.1937.777.24.5.2.1;fhirPolicyUri=urn:oid:2.16.840.1.113883.3.1937.777.24.2.2718;fhirConsentCategory=2.16.840.1.113883.3.1937.777.24.2.184;fhirAnswerCodeNo=2.16.840.1.113883.3.1937.777.24.5.2.2;fhirAnswerCodeUnknown=2.16.840.1.113883.3.1937.777.24.5.2.3;fhirAnswerDisplayYes=gültig;fhirAnswerDisplayNo=ungültig;fhirAnswerDisplayUnknown=unbekannt', '', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'REVOCATION', 'MII_###_Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_FOOTER', 'MII_###_Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_HEADER', 'MII_###_Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000', '2022-02-01 09:13:43.508', '2022-02-01 12:01:49.710', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', '2.0', 1, '9b095de2-bbff-47f8-aba8-f8ee39b37481', NULL),
	('Demo Deutschland_###_Widerruf Datenerhebung_###_1000_###_TEMPLATE_TITLE', '', '', '', 'Widerruf Datenerhebung', 1000, 'Demo Deutschland', 'REVOCATION', 'Demo Deutschland_###_Widerruf Datenerhebung_###_1000_###_FOOTER', 'Demo Deutschland_###_Widerruf Datenerhebung_###_1000_###_HEADER', 'Demo Deutschland_###_Widerruf Datenerhebung_###_1000', '2022-02-01 09:15:26.393', '2022-02-01 09:16:10.713', 'Widerruf Datenerhebung', NULL, 1, '8625da29-fa14-40b5-b881-0798b49f7c75', NULL),
	('Demo EU_###_Withdrawal Data Collection_###_1000_###_TEMPLATE_TITLE', '', '', '', 'Withdrawal Data Collection', 1000, 'Demo EU', 'REVOCATION', 'Demo EU_###_Withdrawal Data Collection_###_1000_###_FOOTER', 'Demo EU_###_Withdrawal Data Collection_###_1000_###_HEADER', 'Demo EU_###_Withdrawal Data Collection_###_1000', '2022-02-01 09:15:40.707', '2022-02-01 09:20:21.238', 'Withdrawal Data Collection', NULL, 1, '8266e9fc-b629-4f95-8a37-53a5d6d134ef', NULL);

-- Exportiere Daten aus Tabelle gics.consent_template_scan: ~7 rows (ungefähr)
INSERT IGNORE INTO `consent_template_scan` (`ID`, `SCANBASE64`, `FILETYPE`) VALUES
	('Demo Deutschland_###_Einwilligung Demostudie_###_1000', '', ''),
	('Demo Deutschland_###_Widerruf Datenerhebung_###_1000', '', ''),
	('Demo EU_###_Consent Demostudy_###_1000', '', ''),
	('Demo EU_###_Withdrawal Data Collection_###_1000', '', ''),
	('MII_###_Patienteneinwilligung MII_###_1006003', '', ''),
	('MII_###_Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000', '', ''),
	('MII_###_Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000', '', '');

-- Exportiere Daten aus Tabelle gics.domain: ~3 rows (ungefähr)
INSERT IGNORE INTO `domain` (`NAME`, `COMMENT`, `CT_VERSION_CONVERTER`, `EXTERN_PROPERTIES`, `EXPIRATION_PROPERTIES`, `LABEL`, `MODULE_VERSION_CONVERTER`, `POLICY_VERSION_CONVERTER`, `CONFIG`, `LOGO`, `FINALISED`, `CREATE_TIMESTAMP`, `UPDATE_TIMESTAMP`, `LAST_CHECK_TIMESTAMP`, `FHIR_ID`) VALUES
	('Demo Deutschland', 'Beispiel Domäne für die Durchführung einer Studie in Deutschland', 'org.emau.icmvc.ganimed.ttp.cm2.version.MajorMinorVersionConverter', '', '', 'Demo Deutschland', 'org.emau.icmvc.ganimed.ttp.cm2.version.MajorMinorVersionConverter', 'org.emau.icmvc.ganimed.ttp.cm2.version.MajorMinorVersionConverter', ';VALID_QC_TYPES=not_checked,checked_no_faults,checked_minor_faults;INVALID_QC_TYPES=checked_major_faults,invalidated;DEFAULT_QC_TYPE=not_checked;STATISTIC_DOCUMENT_DETAILS=true;STATISTIC_POLICY_DETAILS=true;SCANS_ARE_NOT_MANDATORY_FOR_ACCEPTED_CONSENTS=true', NULL, 1, '2022-02-01 09:15:26.306', '2022-02-01 09:15:26.315', NULL, 'fabebe68-19de-4149-8f5c-40ac1f3991a5'),
	('Demo EU', 'Example domain for the execution of a study in europe', 'org.emau.icmvc.ganimed.ttp.cm2.version.MajorMinorVersionConverter', '', '', 'Demo EU', 'org.emau.icmvc.ganimed.ttp.cm2.version.MajorMinorVersionConverter', 'org.emau.icmvc.ganimed.ttp.cm2.version.MajorMinorVersionConverter', ';VALID_QC_TYPES=not_checked,checked_no_faults,checked_minor_faults;INVALID_QC_TYPES=checked_major_faults,invalidated;DEFAULT_QC_TYPE=not_checked;STATISTIC_DOCUMENT_DETAILS=true;STATISTIC_POLICY_DETAILS=true;SCANS_ARE_NOT_MANDATORY_FOR_ACCEPTED_CONSENTS=true', NULL, 1, '2022-02-01 09:15:40.644', '2022-02-01 09:15:40.646', NULL, '0de0d33f-29b7-4364-907f-60948e5864b5'),
	('MII', 'Medizininformatik Initiative', 'org.emau.icmvc.ganimed.ttp.cm2.version.MajorMinorCharVersionConverter', 'fhirForceProfileConsent=https://www.medizininformatik-initiative.de/fhir/modul-consent/StructureDefinition/mii-pr-consent-einwilligung;fhirSafeSignerIdType = Pseudonym', '', 'MII', 'org.emau.icmvc.ganimed.ttp.cm2.version.MajorMinorVersionConverter', 'org.emau.icmvc.ganimed.ttp.cm2.version.MajorMinorVersionConverter', 'SAFE_SIGNERID_TYPE = Pseudonym;VALID_QC_TYPES=not_checked,checked_no_faults,checked_minor_faults;INVALID_QC_TYPES=checked_major_faults,invalidated;DEFAULT_QC_TYPE=not_checked;STATISTIC_DOCUMENT_DETAILS=true;STATISTIC_POLICY_DETAILS=true;SCANS_ARE_NOT_MANDATORY_FOR_ACCEPTED_CONSENTS=true', NULL, 1, '2022-02-01 09:13:27.789', '2022-02-01 09:49:16.052', NULL, 'c946ae17-e3e6-4178-b5ea-15f95aaeeeb4');

-- Exportiere Daten aus Tabelle gics.free_text_def: ~0 rows (ungefähr)

-- Exportiere Daten aus Tabelle gics.free_text_val: ~0 rows (ungefähr)

-- Exportiere Daten aus Tabelle gics.mapped_consent_template: ~0 rows (ungefähr)

-- Exportiere Daten aus Tabelle gics.module: ~35 rows (ungefähr)
INSERT IGNORE INTO `module` (`COMMENT`, `EXTERN_PROPERTIES`, `TITLE`, `NAME`, `VERSION`, `DOMAIN_NAME`, `TEXT`, `SHORT_TEXT`, `CREATE_TIMESTAMP`, `UPDATE_TIMESTAMP`, `LABEL`, `FINALISED`, `FHIR_ID`) VALUES
	('', '', 'MII_###_BIOMAT_Erhebungsende_###_2000_###_MODULE_TITLE', 'BIOMAT_Erhebungsende', 2000, 'MII', 'MII_###_BIOMAT_Erhebungsende_###_2000_###_MODUL', '', '2022-02-01 09:13:43.403', '2022-02-01 09:23:51.700', 'BIOMAT_Erhebungsende', 1, '2e513a6-60bd3-4df7-9a53-10e8f5590f65'),
	('', '', 'MII_###_BIOMAT_Intro_###_1006_###_MODULE_TITLE', 'BIOMAT_Intro', 1006, 'MII', 'MII_###_BIOMAT_Intro_###_1006_###_MODUL', '', '2022-02-01 09:13:28.452', '2022-02-01 09:49:16.097', 'BIOMAT_Intro', 1, '75beb9e-a1536-430b-a1b5-c555cf523799'),
	('', '', 'MII_###_BIOMAT_Vernichtung_###_2000_###_MODULE_TITLE', 'BIOMAT_Vernichtung', 2000, 'MII', 'MII_###_BIOMAT_Vernichtung_###_2000_###_MODUL', '', '2022-02-01 09:13:43.308', '2022-02-01 09:23:51.706', 'BIOMAT_Vernichtung', 1, 'b8b4244-8edc6-408b-8db6-50c1815ed0b5'),
	('', 'fhirQuestionCode=2.16.840.1.113883.3.1937.777.24.2.1596', 'MII_###_BIOMAT_Zusatzentnahme_###_1008_###_MODULE_TITLE', 'BIOMAT_Zusatzentnahme', 1008, 'MII', 'MII_###_BIOMAT_Zusatzentnahme_###_1008_###_MODUL', '', '2022-02-01 09:13:28.457', '2022-02-01 09:49:16.099', 'BIOMAT_Zusatzentnahme', 1, 'e217d4b-df292-4761-8c04-27dffa9abe2b'),
	('', '', 'MII_###_BIOMAT_Zusatzmengen_Erhebungsende_###_2000_###_MODULE_TITLE', 'BIOMAT_Zusatzmengen_Erhebungsende', 2000, 'MII', 'MII_###_BIOMAT_Zusatzmengen_Erhebungsende_###_2000_###_MODUL', '', '2022-02-01 09:13:43.388', '2022-02-01 09:23:51.702', 'BIOMAT_Zusatzmengen_Erhebungsende', 1, '03090d8-d1f47-4b35-8107-e763cfa77195'),
	('erheben, lagern, nutzen, eigentum übertragen, analysedaten zusammenführen', 'fhirQuestionCode=2.16.840.1.113883.3.1937.777.24.2.1595', 'MII_###_BIOMAT_erheben_lagern_nutzen_###_1008_###_MODULE_TITLE', 'BIOMAT_erheben_lagern_nutzen', 1008, 'MII', 'MII_###_BIOMAT_erheben_lagern_nutzen_###_1008_###_MODUL', '', '2022-02-01 09:13:28.308', '2022-02-01 09:49:16.076', 'BIOMAT_erheben_lagern_nutzen', 1, '0740c26-231af-4d50-aac4-41cd08526e84'),
	('', '', 'Demo Deutschland_###_Biomaterial_###_1000_###_MODULE_TITLE', 'Biomaterial', 1000, 'Demo Deutschland', 'Demo Deutschland_###_Biomaterial_###_1000_###_MODUL', '', '2022-02-01 09:15:26.354', '2022-02-01 09:16:12.569', 'Biomaterial', 1, 'a2ce95c-4b959-445c-91d6-e74f77a314f5'),
	('', '', 'Demo EU_###_Biomaterial_###_1000_###_MODULE_TITLE', 'Biomaterial', 1000, 'Demo EU', 'Demo EU_###_Biomaterial_###_1000_###_MODUL', '', '2022-02-01 09:15:40.681', '2022-02-01 09:20:22.665', 'Biomaterial', 1, '9df8061-5a15c-4766-8717-68514f495f31'),
	('', '', 'Demo Deutschland_###_Datenschutzerklärung_###_1000_###_MODULE_TITLE', 'Datenschutzerklärung', 1000, 'Demo Deutschland', 'Demo Deutschland_###_Datenschutzerklärung_###_1000_###_MODUL', '', '2022-02-01 09:15:26.349', '2022-02-01 09:16:12.562', 'Datenschutzerklärung', 1, '01fb7b6-a2a52-4db5-87f2-b9aadba2ba2b'),
	('', '', 'MII_###_Geltungsdauer_###_1006_###_MODULE_TITLE', 'Geltungsdauer', 1006, 'MII', 'MII_###_Geltungsdauer_###_1006_###_MODUL', '', '2022-02-01 09:13:28.291', '2022-02-01 09:49:16.073', 'Geltungsdauer', 1, '39c6dc2-876ae-4cd5-bb93-5e32fe0bb36a'),
	('', '', 'MII_###_KKDAT_Intro_###_1006_###_MODULE_TITLE', 'KKDAT_Intro', 1006, 'MII', 'MII_###_KKDAT_Intro_###_1006_###_MODUL', '', '2022-02-01 09:13:28.446', '2022-02-01 09:49:16.095', 'KKDAT_Intro', 1, 'c55d969-9466a-4fbd-99fd-ee80d3617b2c'),
	('', '', 'MII_###_KKDAT_Loeschung_###_2000_###_MODULE_TITLE', 'KKDAT_Loeschung', 2000, 'MII', 'MII_###_KKDAT_Loeschung_###_2000_###_MODUL', '', '2022-02-01 09:13:43.332', '2022-02-01 09:23:51.702', 'KKDAT_Loeschung', 1, '7a69ea3-1385f-497e-982e-57769e365992'),
	('', '', 'MII_###_KKDAT_prospektiv_Uebertragungsende_###_2000_###_MODULE_TITLE', 'KKDAT_prospektiv_Uebertragungsende', 2000, 'MII', 'MII_###_KKDAT_prospektiv_Uebertragungsende_###_2000_###_MODUL', '', '2022-02-01 09:13:43.357', '2022-02-01 09:23:51.702', 'KKDAT_prospektiv_Uebertragungsende', 1, 'e2f8407-f106c-48e3-b41c-2fac7c2add5d'),
	('', 'fhirQuestionCode=2.16.840.1.113883.3.1937.777.24.2.1594', 'MII_###_KKDAT_prospektiv_uebertragen_speichern_nutzen_###_1008_###_MODULE_TITLE', 'KKDAT_prospektiv_uebertragen_speichern_nutzen', 1008, 'MII', 'MII_###_KKDAT_prospektiv_uebertragen_speichern_nutzen_###_1008_###_MODUL', '', '2022-02-01 09:13:28.427', '2022-02-01 09:49:16.089', 'KKDAT_prospektiv_uebertragen_speichern_nutzen', 1, 'fe77a81-c023d-4b2e-bbd6-34ed9da31bfb'),
	('', '', 'MII_###_KKDAT_retrospektiv_Uebertragungsende_###_2000_###_MODULE_TITLE', 'KKDAT_retrospektiv_Uebertragungsende', 2000, 'MII', 'MII_###_KKDAT_retrospektiv_Uebertragungsende_###_2000_###_MODUL', '', '2022-02-01 09:13:43.425', '2022-02-01 09:23:51.702', 'KKDAT_retrospektiv_Uebertragungsende', 1, 'ff7cd8b-ae473-43be-9fd4-267f5ff69236'),
	('', 'fhirQuestionCode=2.16.840.1.113883.3.1937.777.24.2.1593', 'MII_###_KKDAT_retrospektiv_uebertragen_speichern_nutzen_###_1008_###_MODULE_TITLE', 'KKDAT_retrospektiv_uebertragen_speichern_nutzen', 1008, 'MII', 'MII_###_KKDAT_retrospektiv_uebertragen_speichern_nutzen_###_1008_###_MODUL', '', '2022-02-01 09:13:28.407', '2022-02-01 09:49:16.083', 'KKDAT_retrospektiv_uebertragen_speichern_nutzen', 1, '499f3d8-474c4-4168-9db5-1c516f93c4c1'),
	('', '', 'MII_###_Kontaktsperre_Informationen_wissenschaftliche_Fragen_neue_Studien_###_2000_###_MODULE_TITLE', 'Kontaktsperre_Informationen_wissenschaftliche_Fragen_neue_Studien', 2000, 'MII', 'MII_###_Kontaktsperre_Informationen_wissenschaftliche_Fragen_neue_Studien_###_2000_###_MODUL', '', '2022-02-01 09:13:43.193', '2022-02-01 09:23:51.702', 'Kontaktsperre_Informationen_wissenschaftliche_Fragen_neue_Studien', 1, '4db9167-3c61a-4c9d-a195-1e1012372149'),
	('', '', 'MII_###_Kontaktsperre_gesundheitsrelevante_Analyseergebnisse_###_2000_###_MODULE_TITLE', 'Kontaktsperre_gesundheitsrelevante_Analyseergebnisse', 2000, 'MII', 'MII_###_Kontaktsperre_gesundheitsrelevante_Analyseergebnisse_###_2000_###_MODUL', '', '2022-02-01 09:13:43.416', '2022-02-01 09:23:51.700', 'Kontaktsperre_gesundheitsrelevante_Analyseergebnisse', 1, 'c8ea8d7-7d052-41a4-89e5-5066324937a4'),
	('', '', 'MII_###_PATDAT_BIOMAT_KKDAT_komplett_widerrufen_###_2000_###_MODULE_TITLE', 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 2000, 'MII', 'MII_###_PATDAT_BIOMAT_KKDAT_komplett_widerrufen_###_2000_###_MODUL', '', '2022-02-01 09:13:43.450', '2022-02-01 09:23:49.128', 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 1, '33a17a3-d01ad-4133-abb2-64c4c3d482e0'),
	('', '', 'MII_###_PATDAT_Erhebungsende_###_2000_###_MODULE_TITLE', 'PATDAT_Erhebungsende', 2000, 'MII', 'MII_###_PATDAT_Erhebungsende_###_2000_###_MODUL', '', '2022-02-01 09:13:43.346', '2022-02-01 09:23:51.702', 'PATDAT_Erhebungsende', 1, 'c74a8f0-e2ce2-438e-8e65-84464d14ad67'),
	('', '', 'MII_###_PATDAT_Intro_###_1006_###_MODULE_TITLE', 'PATDAT_Intro', 1006, 'MII', 'MII_###_PATDAT_Intro_###_1006_###_MODUL', '', '2022-02-01 09:13:28.440', '2022-02-01 09:49:16.093', 'PATDAT_Intro', 1, '43356f7-c5d08-492b-8b08-fa764a407cc9'),
	('', '', 'MII_###_PATDAT_Loeschung_###_2000_###_MODULE_TITLE', 'PATDAT_Loeschung', 2000, 'MII', 'MII_###_PATDAT_Loeschung_###_2000_###_MODUL', '', '2022-02-01 09:13:43.219', '2022-02-01 09:23:51.701', 'PATDAT_Loeschung', 1, 'fa3deb7-e5680-4f3c-813a-dd14e8360e81'),
	('', 'fhirQuestionCode=2.16.840.1.113883.3.1937.777.24.2.1567', 'MII_###_PATDAT_erheben_speichern_nutzen_###_1008_###_MODULE_TITLE', 'PATDAT_erheben_speichern_nutzen', 1008, 'MII', 'MII_###_PATDAT_erheben_speichern_nutzen_###_1008_###_MODUL', '', '2022-02-01 09:13:28.416', '2022-02-01 09:49:16.085', 'PATDAT_erheben_speichern_nutzen', 1, 'c97209b-ee12b-4c60-82f3-dc5b8e8e3d91'),
	('', '', 'Demo EU_###_Privacy Statement_###_1000_###_MODULE_TITLE', 'Privacy Statement', 1000, 'Demo EU', 'Demo EU_###_Privacy Statement_###_1000_###_MODUL', '', '2022-02-01 09:15:40.687', '2022-02-01 09:20:22.664', 'Privacy Statement', 1, '21bdd92-545ba-4237-8054-ebc591b4affa'),
	('', '', 'Demo EU_###_Recontact_###_1000_###_MODULE_TITLE', 'Recontact', 1000, 'Demo EU', 'Demo EU_###_Recontact_###_1000_###_MODUL', '', '2022-02-01 09:15:40.692', '2022-02-01 09:20:22.665', 'Recontact', 1, '4fa3699-3dcb9-4e30-8772-dd4bc2ead1fb'),
	('', '', 'Demo Deutschland_###_Rekontaktierung_###_1000_###_MODULE_TITLE', 'Rekontaktierung', 1000, 'Demo Deutschland', 'Demo Deutschland_###_Rekontaktierung_###_1000_###_MODUL', '', '2022-02-01 09:15:26.376', '2022-02-01 09:16:12.562', 'Rekontaktierung', 1, 'b629f51-e5d7e-4b9b-a711-d5f1765881f6'),
	('', 'fhirQuestionCode=2.16.840.1.113883.3.1937.777.24.2.1597', 'MII_###_Rekontaktierung_Ergaenzungen_###_1007_###_MODULE_TITLE', 'Rekontaktierung_Ergaenzungen', 1007, 'MII', 'MII_###_Rekontaktierung_Ergaenzungen_###_1007_###_MODUL', '', '2022-02-01 09:13:28.379', '2022-02-01 09:49:16.079', 'Rekontaktierung_Ergaenzungen', 1, 'ffbeb2c-be7d7-4e21-95ba-ccde79d88ddd'),
	('', '', 'MII_###_Rekontaktierung_Intro_###_1006_###_MODULE_TITLE', 'Rekontaktierung_Intro', 1006, 'MII', 'MII_###_Rekontaktierung_Intro_###_1006_###_MODUL', '', '2022-02-01 09:13:28.240', '2022-02-01 09:49:16.071', 'Rekontaktierung_Intro', 1, '94c2a3b-20e3c-4706-a9d5-015f836a88cf'),
	('', 'fhirQuestionCode=2.16.840.1.113883.3.1937.777.24.2.1598', 'MII_###_Rekontaktierung_Zusatzbefund_###_1008_###_MODULE_TITLE', 'Rekontaktierung_Zusatzbefund', 1008, 'MII', 'MII_###_Rekontaktierung_Zusatzbefund_###_1008_###_MODUL', '', '2022-02-01 09:13:28.435', '2022-02-01 09:49:16.091', 'Rekontaktierung_Zusatzbefund', 1, '86dd8bd-0aeeb-472d-b7e0-8e61272acd68'),
	('', '', 'Demo Deutschland_###_Widerruf Datenerhebung_###_1000_###_MODULE_TITLE', 'Widerruf Datenerhebung', 1000, 'Demo Deutschland', 'Demo Deutschland_###_Widerruf Datenerhebung_###_1000_###_MODUL', '', '2022-02-01 09:15:26.380', '2022-02-01 09:16:10.713', 'Widerruf Datenerhebung', 1, '40d016b-f59fa-44b3-92bb-249f977ec0b5'),
	('', '', 'MII_###_Widerrufsintro_teilweise_###_1000_###_MODULE_TITLE', 'Widerrufsintro_teilweise', 1000, 'MII', 'MII_###_Widerrufsintro_teilweise_###_1000_###_MODUL', 'Einheitlicher Header für vollständige Widerrufsformulare', '2022-02-01 09:13:43.322', '2022-02-01 09:23:51.702', 'Widerrufsintro_teilweise', 1, 'f7f0005-0b2b8-45e1-b70d-14ae8e1bedda'),
	('', '', 'MII_###_Widerrufsintro_vollstaendig_###_1000_###_MODULE_TITLE', 'Widerrufsintro_vollstaendig', 1000, 'MII', 'MII_###_Widerrufsintro_vollstaendig_###_1000_###_MODUL', 'Einheitlicher Header für vollständige Widerrufsformulare', '2022-02-01 09:13:43.461', '2022-02-01 09:23:49.125', 'Widerrufsintro_vollstaendig', 1, 'd8ae36c-9da5a-43ae-8bbc-3521f128df17'),
	('', '', 'MII_###_Widerrufsrecht_###_1006_###_MODULE_TITLE', 'Widerrufsrecht', 1006, 'MII', 'MII_###_Widerrufsrecht_###_1006_###_MODUL', '', '2022-02-01 09:13:28.394', '2022-02-01 09:49:16.081', 'Widerrufsrecht', 1, '509b6bd-54dd6-45a9-85d0-aec357ce8ecd'),
	('', '', 'MII_###_Widerrufsvermerk_###_1000_###_MODULE_TITLE', 'Widerrufsvermerk', 1000, 'MII', 'MII_###_Widerrufsvermerk_###_1000_###_MODUL', '', '2022-02-01 09:13:43.293', '2022-02-01 09:23:51.702', 'Widerrufsvermerk', 1, 'c657d12-18422-4e79-812b-2a3cf4589364'),
	('', '', 'Demo EU_###_Withdrawal Data Collection_###_1000_###_MODULE_TITLE', 'Withdrawal Data Collection', 1000, 'Demo EU', 'Demo EU_###_Withdrawal Data Collection_###_1000_###_MODUL', '', '2022-02-01 09:15:40.696', '2022-02-01 09:20:21.238', 'Withdrawal Data Collection', 1, 'e68af2f-11380-4a13-920e-5e6ca1ff20a6');

-- Exportiere Daten aus Tabelle gics.module_consent_template: ~36 rows (ungefähr)
INSERT IGNORE INTO `module_consent_template` (`COMMENT`, `DEFAULTCONSENTSTATUS`, `DISPLAYCHECKBOXES`, `EXTERN_PROPERTIES`, `MANDATORY`, `ORDER_NUMBER`, `CT_DOMAIN`, `CT_NAME`, `CT_VERSION`, `M_DOMAIN`, `M_NAME`, `M_VERSION`, `PARENT_M_DOMAIN`, `PARENT_M_NAME`, `PARENT_M_VERSION`, `EXPIRATION_PROPERTIES`, `FHIR_ID`) VALUES
	(NULL, NULL, 3, NULL, b'0', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Biomaterial', 1000, NULL, NULL, NULL, '', '085f3d4f-aa1d-413e-87af-f35f9a8b361f'),
	(NULL, NULL, 3, NULL, b'1', 0, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Datenschutzerklärung', 1000, NULL, NULL, NULL, '', 'bd4718ab-c7bd-4680-ac32-9ad85e703190'),
	(NULL, NULL, 3, NULL, b'0', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Rekontaktierung', 1000, NULL, NULL, NULL, '', 'dc3e3e13-886c-4f91-9dbc-8fff587448e4'),
	(NULL, NULL, 32, NULL, b'0', 0, 'Demo Deutschland', 'Widerruf Datenerhebung', 1000, 'Demo Deutschland', 'Widerruf Datenerhebung', 1000, NULL, NULL, NULL, '', '8fd462fc-0c4e-4023-93b9-1e22acdcc803'),
	(NULL, NULL, 3, NULL, b'0', 1, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Biomaterial', 1000, NULL, NULL, NULL, '', '6d2fc1cc-2a9e-4d9d-b4a2-26bfe5b9942c'),
	(NULL, NULL, 3, NULL, b'1', 0, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Privacy Statement', 1000, NULL, NULL, NULL, '', 'dc20c78b-19d2-4e00-96ce-633dc9850d3d'),
	(NULL, NULL, 3, NULL, b'0', 2, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Recontact', 1000, NULL, NULL, NULL, '', 'f2cc92f4-df10-4713-83b8-ff5995482910'),
	(NULL, NULL, 32, NULL, b'0', 0, 'Demo EU', 'Withdrawal Data Collection', 1000, 'Demo EU', 'Withdrawal Data Collection', 1000, NULL, NULL, NULL, '', '0454a967-852b-4192-8cfc-05178775091d'),
	(NULL, NULL, 0, NULL, b'0', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Intro', 1006, NULL, NULL, NULL, '', 'f757355d-d337-4378-b882-ebc1a50cbdd9'),
	(NULL, NULL, 3, NULL, b'0', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Zusatzentnahme', 1008, NULL, NULL, NULL, '', 'a5ddecd5-8e06-4ced-a219-d6e78c40b548'),
	(NULL, NULL, 3, NULL, b'0', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_erheben_lagern_nutzen', 1008, NULL, NULL, NULL, '', 'f8133cf5-f5ca-4681-80c5-24979d0812f4'),
	(NULL, NULL, 0, NULL, b'0', 13, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Geltungsdauer', 1006, NULL, NULL, NULL, '', '24be0423-be1d-47c6-86d2-1a59a2dadc73'),
	(NULL, NULL, 0, NULL, b'0', 2, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_Intro', 1006, NULL, NULL, NULL, '', 'd8d8c84f-b2c2-4174-b680-43580ace9c08'),
	(NULL, NULL, 3, NULL, b'0', 4, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_prospektiv_uebertragen_speichern_nutzen', 1008, NULL, NULL, NULL, '', 'de87bf54-22d1-4527-ba84-43a159c0feed'),
	(NULL, NULL, 3, NULL, b'0', 3, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_retrospektiv_uebertragen_speichern_nutzen', 1008, NULL, NULL, NULL, '', '0bae5e3d-156d-4493-9e58-4bb50140606b'),
	(NULL, NULL, 0, NULL, b'0', 0, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'PATDAT_Intro', 1006, NULL, NULL, NULL, '', 'e878c209-9549-4379-8e3e-6eedb504c73c'),
	(NULL, NULL, 3, NULL, b'1', 1, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'PATDAT_erheben_speichern_nutzen', 1008, NULL, NULL, NULL, '', '66e428af-dafb-4006-b207-87bbcb031c5a'),
	(NULL, NULL, 3, NULL, b'0', 9, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Ergaenzungen', 1007, NULL, NULL, NULL, '', 'd53f23e3-7936-49ce-bab5-9c78322b5b2e'),
	(NULL, NULL, 0, NULL, b'0', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Intro', 1006, NULL, NULL, NULL, '', 'bba5dfed-e523-4e91-b335-40dd2142abdd'),
	(NULL, NULL, 3, NULL, b'0', 10, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Zusatzbefund', 1008, NULL, NULL, NULL, '', '2541a2c5-f4ff-49c2-b2b2-d7a1698d1455'),
	(NULL, NULL, 0, NULL, b'0', 14, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Widerrufsrecht', 1006, NULL, NULL, NULL, '', '4a74da3c-1de8-40d1-876e-e03904178414'),
	(NULL, NULL, 48, '', b'0', 5, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_Erhebungsende', 2000, NULL, NULL, NULL, '', 'e4340c3e-81c2-417b-9461-81e21e88717a'),
	(NULL, NULL, 48, '', b'0', 8, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_Vernichtung', 2000, NULL, NULL, NULL, '', '3019f652-c82c-4410-b69f-a3563c9a8fef'),
	(NULL, NULL, 48, '', b'0', 4, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_Zusatzmengen_Erhebungsende', 2000, NULL, NULL, NULL, '', '65e86f20-0717-4277-8899-593285735152'),
	(NULL, NULL, 48, '', b'0', 9, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_Loeschung', 2000, NULL, NULL, NULL, '', '5c2ae454-ebc1-44d3-9d66-9ea598904a85'),
	(NULL, NULL, 48, '', b'0', 6, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_prospektiv_Uebertragungsende', 2000, NULL, NULL, NULL, '', 'cb965dac-92cc-4130-9b7b-cbb17ff6d217'),
	(NULL, NULL, 48, '', b'0', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_retrospektiv_Uebertragungsende', 2000, NULL, NULL, NULL, '', '5aef0134-0c23-46d9-b06a-7ec375646236'),
	(NULL, NULL, 48, '', b'0', 1, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Kontaktsperre_Informationen_wissenschaftliche_Fragen_neue_Studien', 2000, NULL, NULL, NULL, '', '7c2ec6c1-50b3-48c5-b282-c3b8a6520fcf'),
	(NULL, NULL, 48, '', b'0', 2, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Kontaktsperre_gesundheitsrelevante_Analyseergebnisse', 2000, NULL, NULL, NULL, '', '74516d02-d0e1-46c2-850d-9e195f515dd0'),
	(NULL, NULL, 48, '', b'0', 3, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'PATDAT_Erhebungsende', 2000, NULL, NULL, NULL, '', '53daa6ae-ee59-4d33-8212-68c1f8a9ff19'),
	(NULL, NULL, 48, '', b'0', 10, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'PATDAT_Loeschung', 2000, NULL, NULL, NULL, '', '8e0d7173-bf3a-4e09-bdaa-e94c25ddd3bf'),
	(NULL, 4, 0, '', b'0', 0, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Widerrufsintro_teilweise', 1000, NULL, NULL, NULL, '', 'b47d08b3-c6d4-4045-8ff5-1018986fe9af'),
	(NULL, 4, 0, '', b'0', 11, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Widerrufsvermerk', 1000, NULL, NULL, NULL, '', '26f1c476-60e6-4cab-8f26-f50f12aacb1d'),
	(NULL, NULL, 48, '', b'1', 1, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 2000, NULL, NULL, NULL, '', '4e071f9b-b10a-4fd5-928c-f67b959fb180'),
	(NULL, 4, 0, '', b'0', 0, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Widerrufsintro_vollstaendig', 1000, NULL, NULL, NULL, '', '2797ab13-aa4c-4444-b45c-75ff5502c61f'),
	(NULL, 4, 0, '', b'0', 2, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Widerrufsvermerk', 1000, NULL, NULL, NULL, '', '229dafba-f0b5-404b-9d6b-33cdb1a467e6');

-- Exportiere Daten aus Tabelle gics.module_policy: ~105 rows (ungefähr)
INSERT IGNORE INTO `module_policy` (`P_NAME`, `P_DOMAIN_NAME`, `P_VERSION`, `M_NAME`, `M_DOMAIN_NAME`, `M_VERSION`, `COMMENT`, `EXTERN_PROPERTIES`, `EXPIRATION_PROPERTIES`, `FHIR_ID`) VALUES
	('BIOMAT_Analysedaten_zusammenfuehren_Dritte', 'MII', 1001, 'BIOMAT_Vernichtung', 'MII', 2000, NULL, NULL, '', '7e0a9221-ce31-4dce-8f02-a0d6eabc1f6f'),
	('BIOMAT_Analysedaten_zusammenfuehren_Dritte', 'MII', 1001, 'BIOMAT_erheben_lagern_nutzen', 'MII', 1008, NULL, NULL, '', '61f097c2-b380-4221-b255-c1e1cd939a67'),
	('BIOMAT_Analysedaten_zusammenfuehren_Dritte', 'MII', 1001, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '173e5c47-4243-47c8-8f9c-c5d4d67c1231'),
	('BIOMAT_Eigentum_uebertragen', 'MII', 1000, 'BIOMAT_Vernichtung', 'MII', 2000, NULL, NULL, '', '94a7a136-89c6-486d-92fa-e50f5c37ca26'),
	('BIOMAT_Eigentum_uebertragen', 'MII', 1000, 'BIOMAT_erheben_lagern_nutzen', 'MII', 1008, NULL, NULL, 'VALIDITY_PERIOD=P5Y;', 'ec125688-2131-492a-ab5b-1b70ce169833'),
	('BIOMAT_Eigentum_uebertragen', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '34605f3a-ee96-4cd1-a134-1b556832efb7'),
	('BIOMAT_Zusatzmengen_entnehmen', 'MII', 1000, 'BIOMAT_Zusatzentnahme', 'MII', 1008, 'Automatischer Ablauf nach 5 Jahren', NULL, 'VALIDITY_PERIOD=P5Y;', 'a999ab6d-9053-4d5f-86b6-86b5e9df3948'),
	('BIOMAT_Zusatzmengen_entnehmen', 'MII', 1000, 'BIOMAT_Zusatzmengen_Erhebungsende', 'MII', 2000, NULL, NULL, '', 'eab32177-8fea-4396-8531-62cbc652bfb5'),
	('BIOMAT_Zusatzmengen_entnehmen', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '8ae244bd-6c81-4692-8eee-73862854bc53'),
	('BIOMAT_erheben', 'MII', 1001, 'BIOMAT_Erhebungsende', 'MII', 2000, NULL, NULL, '', '4908382f-d61b-4fec-b896-70e0cd506c44'),
	('BIOMAT_erheben', 'MII', 1001, 'BIOMAT_erheben_lagern_nutzen', 'MII', 1008, 'Automatischer Ablauf nach 5 Jahren', NULL, 'VALIDITY_PERIOD=P5Y;', 'fda9b186-fc8b-47a0-ba8d-bb71b9055803'),
	('BIOMAT_erheben', 'MII', 1001, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', 'abc80273-949c-4398-be0b-a86f20944e34'),
	('BIOMAT_lagern_verarbeiten', 'MII', 1000, 'BIOMAT_Vernichtung', 'MII', 2000, NULL, NULL, '', '8d9cdaca-e631-4768-a972-166b6012fa1b'),
	('BIOMAT_lagern_verarbeiten', 'MII', 1000, 'BIOMAT_erheben_lagern_nutzen', 'MII', 1008, NULL, NULL, '', '575c1986-b4de-420a-88c3-848580f5e2e8'),
	('BIOMAT_lagern_verarbeiten', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '594868f9-768e-4611-9862-e89a446d810f'),
	('BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 'MII', 1000, 'BIOMAT_Vernichtung', 'MII', 2000, NULL, NULL, '', 'a26ab9f7-b5ef-43f6-adf6-3a0ffa57dc7c'),
	('BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 'MII', 1000, 'BIOMAT_erheben_lagern_nutzen', 'MII', 1008, NULL, NULL, '', '5d5ca34d-73df-4ed1-9332-3584b55393d6'),
	('BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '52abf915-9c73-4674-9a25-9a02922ffd29'),
	('Biomaterial erheben', 'Demo Deutschland', 1000, 'Biomaterial', 'Demo Deutschland', 1000, NULL, NULL, '', 'e6454e16-01bd-4cbb-b607-d3faa6153e69'),
	('Biomaterial erheben', 'Demo Deutschland', 1000, 'Widerruf Datenerhebung', 'Demo Deutschland', 1000, NULL, NULL, '', 'e1fac464-4cb3-438c-b34d-39716a9f5f3a'),
	('Biomaterial herausgeben', 'Demo Deutschland', 1000, 'Biomaterial', 'Demo Deutschland', 1000, NULL, NULL, '', 'df710c7a-7812-47d0-b3c8-472c76bfdc83'),
	('Biomaterial lagern', 'Demo Deutschland', 1000, 'Biomaterial', 'Demo Deutschland', 1000, NULL, NULL, '', '667db557-35d7-4047-9efc-65df3a1e2a55'),
	('Collect Biomaterial', 'Demo EU', 1000, 'Biomaterial', 'Demo EU', 1000, NULL, NULL, '', 'a532e3f6-4ac3-4dc0-be87-51ed168e444e'),
	('Collect Biomaterial', 'Demo EU', 1000, 'Withdrawal Data Collection', 'Demo EU', 1000, NULL, NULL, '', 'b264d802-9dd3-4b82-9ecf-417bb26470cc'),
	('Collect Identifying Data', 'Demo EU', 1000, 'Privacy Statement', 'Demo EU', 1000, NULL, NULL, '', '2b2dac1e-2c08-4e8e-9aeb-d4afe63c9fbe'),
	('Collect Identifying Data', 'Demo EU', 1000, 'Withdrawal Data Collection', 'Demo EU', 1000, NULL, NULL, '', 'bb5d1e56-319a-44fd-9b6a-e47911fe5362'),
	('Collect Medical Data', 'Demo EU', 1000, 'Privacy Statement', 'Demo EU', 1000, NULL, NULL, '', 'f06dead8-0f36-4e90-a3ad-026d2dd155b2'),
	('Collect Medical Data', 'Demo EU', 1000, 'Withdrawal Data Collection', 'Demo EU', 1000, NULL, NULL, '', '443b653c-a9d7-4f8e-b564-c57e632e2599'),
	('IDAT_bereitstellen_EU_DSGVO_konform', 'MII', 1001, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '2d95b998-9002-424e-8344-096ede8b2529'),
	('IDAT_bereitstellen_EU_DSGVO_konform', 'MII', 1001, 'PATDAT_Loeschung', 'MII', 2000, NULL, NULL, '', '74ca35ea-d189-4408-bd43-d1d9c2029326'),
	('IDAT_bereitstellen_EU_DSGVO_konform', 'MII', 1001, 'PATDAT_erheben_speichern_nutzen', 'MII', 1008, NULL, NULL, '', 'b2871938-fd48-4c11-8c8f-92939a1e8d73'),
	('IDAT_erheben', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '5a245247-3b6b-4170-9bfe-bccf97aa4f0e'),
	('IDAT_erheben', 'MII', 1000, 'PATDAT_Erhebungsende', 'MII', 2000, NULL, NULL, '', '0095f52f-faec-4644-9ca2-488c2cfec02d'),
	('IDAT_erheben', 'MII', 1000, 'PATDAT_erheben_speichern_nutzen', 'MII', 1008, NULL, NULL, '', 'ece8e16b-c602-4432-8fe4-dac9190696f4'),
	('IDAT_speichern_verarbeiten', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', 'f2e16529-cb6c-4cf5-aee1-cbfe4bf9ddd6'),
	('IDAT_speichern_verarbeiten', 'MII', 1000, 'PATDAT_Loeschung', 'MII', 2000, NULL, NULL, '', 'f9e30380-addf-4a89-8eb7-e77f22d75b4b'),
	('IDAT_speichern_verarbeiten', 'MII', 1000, 'PATDAT_erheben_speichern_nutzen', 'MII', 1008, NULL, NULL, '', 'b8a5bffc-0537-4035-8bed-33b823795e98'),
	('IDAT_zusammenfuehren_Dritte', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', 'ae5f107c-41ee-46d9-b3e0-44f83ff53700'),
	('IDAT_zusammenfuehren_Dritte', 'MII', 1000, 'PATDAT_Loeschung', 'MII', 2000, NULL, NULL, '', '4f9f10bf-782f-4f78-9cf1-2b49b9d9ac70'),
	('IDAT_zusammenfuehren_Dritte', 'MII', 1000, 'PATDAT_erheben_speichern_nutzen', 'MII', 1008, NULL, NULL, '', '5d61b4e6-2538-4a7f-94dd-8ff4ac7c99dc'),
	('Identifizierende Daten erheben', 'Demo Deutschland', 1000, 'Datenschutzerklärung', 'Demo Deutschland', 1000, NULL, NULL, '', 'b2a0d94c-f421-49c0-a0a7-400940b1e976'),
	('Identifizierende Daten erheben', 'Demo Deutschland', 1000, 'Widerruf Datenerhebung', 'Demo Deutschland', 1000, NULL, NULL, '', '57ad02a9-29cf-454a-9a0e-6f240403bb0e'),
	('Identifizierende Daten speichern', 'Demo Deutschland', 1000, 'Datenschutzerklärung', 'Demo Deutschland', 1000, NULL, NULL, '', '042c6a51-42d7-460a-afa3-a29ab14f7795'),
	('KKDAT_5J_pro_speichern_verarbeiten', 'MII', 1000, 'KKDAT_Loeschung', 'MII', 2000, NULL, NULL, '', '1462244b-c9b6-40a8-a3cb-a16a61826ad1'),
	('KKDAT_5J_pro_speichern_verarbeiten', 'MII', 1000, 'KKDAT_prospektiv_uebertragen_speichern_nutzen', 'MII', 1008, NULL, NULL, '', 'c7de029b-d3f5-44b4-8255-0368516b5bd3'),
	('KKDAT_5J_pro_speichern_verarbeiten', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', 'b312f186-f30a-47d9-b143-11656683272b'),
	('KKDAT_5J_pro_uebertragen', 'MII', 1000, 'KKDAT_prospektiv_Uebertragungsende', 'MII', 2000, NULL, NULL, '', 'bcf87751-9c63-4bc1-b7fe-0698ce4f1a1b'),
	('KKDAT_5J_pro_uebertragen', 'MII', 1000, 'KKDAT_prospektiv_uebertragen_speichern_nutzen', 'MII', 1008, 'Automatischer Ablauf nach 5 Jahren', NULL, 'VALIDITY_PERIOD=P5Y;', 'f1e8f56a-2bae-40c1-aac0-930020d0bca9'),
	('KKDAT_5J_pro_uebertragen', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '19268268-6ed5-47c4-921d-c18f3cbe8f20'),
	('KKDAT_5J_pro_wissenschaftlich_nutzen', 'MII', 1000, 'KKDAT_Loeschung', 'MII', 2000, NULL, NULL, '', 'ad39d022-a0bf-486c-b513-7cdbde7a0dab'),
	('KKDAT_5J_pro_wissenschaftlich_nutzen', 'MII', 1000, 'KKDAT_prospektiv_uebertragen_speichern_nutzen', 'MII', 1008, NULL, NULL, '', '8030cc55-10d7-404e-b184-cf8adea44c5e'),
	('KKDAT_5J_pro_wissenschaftlich_nutzen', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', 'a1ec8116-f1f3-48b5-ab31-7ad7bb1e442d'),
	('KKDAT_5J_retro_speichern_verarbeiten', 'MII', 1001, 'KKDAT_Loeschung', 'MII', 2000, NULL, NULL, '', '1bb530c6-eafe-4566-831a-eec05f9faa8f'),
	('KKDAT_5J_retro_speichern_verarbeiten', 'MII', 1001, 'KKDAT_retrospektiv_uebertragen_speichern_nutzen', 'MII', 1008, NULL, NULL, '', '683aebb7-014d-432c-bda9-43a28f5b1384'),
	('KKDAT_5J_retro_speichern_verarbeiten', 'MII', 1001, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', 'd73202e4-7a2d-4854-9ed6-f093dd41230e'),
	('KKDAT_5J_retro_uebertragen', 'MII', 1000, 'KKDAT_retrospektiv_Uebertragungsende', 'MII', 2000, NULL, NULL, '', 'b6a10b52-6bd0-462c-ba99-2980ccd3a81a'),
	('KKDAT_5J_retro_uebertragen', 'MII', 1000, 'KKDAT_retrospektiv_uebertragen_speichern_nutzen', 'MII', 1008, NULL, 'singleUseOnly=true', '', 'a3cc3c34-acc0-4710-b889-79cbf6ba73b2'),
	('KKDAT_5J_retro_uebertragen', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '9c30d82d-5dd9-4e5c-8462-bfd9cdcf7b43'),
	('KKDAT_5J_retro_wissenschaftlich_nutzen', 'MII', 1000, 'KKDAT_Loeschung', 'MII', 2000, NULL, NULL, '', '706c3e27-cd36-4f91-891d-926862c38f33'),
	('KKDAT_5J_retro_wissenschaftlich_nutzen', 'MII', 1000, 'KKDAT_retrospektiv_uebertragen_speichern_nutzen', 'MII', 1008, NULL, NULL, '', 'f148071d-4d3d-4ac4-a55f-98a169d7e228'),
	('KKDAT_5J_retro_wissenschaftlich_nutzen', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '71a5fd8e-c77d-4a60-8d15-129b427456de'),
	('KKDAT_KVNR_5J_pro_uebertragen', 'MII', 1000, 'KKDAT_prospektiv_Uebertragungsende', 'MII', 2000, NULL, NULL, '', '342477af-9764-4d88-a31a-39907722e6bd'),
	('KKDAT_KVNR_5J_pro_uebertragen', 'MII', 1000, 'KKDAT_prospektiv_uebertragen_speichern_nutzen', 'MII', 1008, 'Automatischer Ablauf nach 5 Jahren', NULL, 'VALIDITY_PERIOD=P5Y;', 'a4f707c4-e806-4c9d-b148-dd7e7bc050a4'),
	('KKDAT_KVNR_5J_pro_uebertragen', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '14eb33d8-320f-4ca6-9302-04a30a054a1a'),
	('KKDAT_KVNR_5J_retro_uebertragen', 'MII', 1000, 'KKDAT_retrospektiv_Uebertragungsende', 'MII', 2000, NULL, NULL, '', '7f172b1c-204c-4872-b812-5fbe303b5adc'),
	('KKDAT_KVNR_5J_retro_uebertragen', 'MII', 1000, 'KKDAT_retrospektiv_uebertragen_speichern_nutzen', 'MII', 1008, NULL, 'singleUseOnly=true', '', 'c1916301-2084-4249-b4e3-ce3739242cac'),
	('KKDAT_KVNR_5J_retro_uebertragen', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '49376d3c-944e-4d64-9b17-20de261a800b'),
	('MDAT_erheben', 'MII', 1001, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', 'e5093dde-67c2-4094-af5d-9412b27dfc7d'),
	('MDAT_erheben', 'MII', 1001, 'PATDAT_Erhebungsende', 'MII', 2000, NULL, NULL, '', '06e023dc-b539-4f6e-b36c-595706fcecfe'),
	('MDAT_erheben', 'MII', 1001, 'PATDAT_erheben_speichern_nutzen', 'MII', 1008, 'Automatischer Ablauf nach 5 Jahren', NULL, 'VALIDITY_PERIOD=P5Y;', '06d49ff4-10a1-4d72-a986-3687273d8f53'),
	('MDAT_speichern_verarbeiten', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '51795852-a2dd-43d0-a6a4-dd7d3d7d0895'),
	('MDAT_speichern_verarbeiten', 'MII', 1000, 'PATDAT_Loeschung', 'MII', 2000, NULL, NULL, '', '685e5df1-3929-4ca6-8426-4da9d86d24f3'),
	('MDAT_speichern_verarbeiten', 'MII', 1000, 'PATDAT_erheben_speichern_nutzen', 'MII', 1008, NULL, NULL, '', 'b6a08dd1-37f9-4827-975b-2e06b1212346'),
	('MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '318fddf9-55ea-471b-9abd-2ebef56d46c6'),
	('MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 'MII', 1000, 'PATDAT_Loeschung', 'MII', 2000, NULL, NULL, '', 'c8c12526-f96c-45cc-a9ee-54564815c35c'),
	('MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 'MII', 1000, 'PATDAT_erheben_speichern_nutzen', 'MII', 1008, NULL, NULL, '', '528e666f-29b0-4e9d-9967-804ce99b3977'),
	('MDAT_zusammenfuehren_Dritte', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '734bae3e-cc20-4591-8624-984b588a2c34'),
	('MDAT_zusammenfuehren_Dritte', 'MII', 1000, 'PATDAT_Loeschung', 'MII', 2000, NULL, NULL, '', '1bfba8f4-c977-4b2c-9e3f-f44de0904a76'),
	('MDAT_zusammenfuehren_Dritte', 'MII', 1000, 'PATDAT_erheben_speichern_nutzen', 'MII', 1008, NULL, NULL, '', 'd8d690c6-bf74-4b73-a476-e4ae05d1bd93'),
	('Medizinische Daten erheben', 'Demo Deutschland', 1000, 'Datenschutzerklärung', 'Demo Deutschland', 1000, NULL, NULL, '', 'df4025be-4a30-42a3-820b-bbf9aecfd7ff'),
	('Medizinische Daten erheben', 'Demo Deutschland', 1000, 'Widerruf Datenerhebung', 'Demo Deutschland', 1000, NULL, NULL, '', 'f4d79444-dcd1-4eda-9b7f-6c987d0dbf2a'),
	('Medizinische Daten herausgeben', 'Demo Deutschland', 1000, 'Datenschutzerklärung', 'Demo Deutschland', 1000, NULL, NULL, '', '6cb975e9-283f-44e3-9748-5893ded852c2'),
	('Medizinische Daten speichern', 'Demo Deutschland', 1000, 'Datenschutzerklärung', 'Demo Deutschland', 1000, NULL, NULL, '', '44cdc65f-83c2-4f40-a0f4-3f645068cd84'),
	('Recontact Follow Up Study', 'Demo EU', 1000, 'Recontact', 'Demo EU', 1000, NULL, NULL, '', '704076e3-6107-4143-8a38-63570e15af90'),
	('Rekontaktierung Folgestudie', 'Demo Deutschland', 1000, 'Rekontaktierung', 'Demo Deutschland', 1000, NULL, NULL, '', '726437e1-9345-4f8c-8979-561ec2a0e902'),
	('Rekontaktierung_Ergebnisse_erheblicher_Bedeutung', 'MII', 1000, 'Kontaktsperre_gesundheitsrelevante_Analyseergebnisse', 'MII', 2000, NULL, NULL, '', '598c8eb3-a6d1-43cb-8c46-a5ccafc10ed1'),
	('Rekontaktierung_Ergebnisse_erheblicher_Bedeutung', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '765f5ddc-e30f-48f7-beb6-7aa52e1ada45'),
	('Rekontaktierung_Ergebnisse_erheblicher_Bedeutung', 'MII', 1000, 'PATDAT_erheben_speichern_nutzen', 'MII', 1008, NULL, NULL, '', '96396cad-b998-467c-86a8-fff1f85c409d'),
	('Rekontaktierung_Verknuepfung_Datenbanken', 'MII', 1000, 'Kontaktsperre_Informationen_wissenschaftliche_Fragen_neue_Studien', 'MII', 2000, NULL, NULL, '', '3940d0ab-8322-437b-819e-91d093bcc28d'),
	('Rekontaktierung_Verknuepfung_Datenbanken', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', 'd2ab7242-3298-4168-b3a3-eea0a6f28cd0'),
	('Rekontaktierung_Verknuepfung_Datenbanken', 'MII', 1000, 'Rekontaktierung_Ergaenzungen', 'MII', 1007, NULL, NULL, '', '2068f24f-1350-4cc8-9755-008cdf1e05f3'),
	('Rekontaktierung_Zusatzbefund', 'MII', 1000, 'Kontaktsperre_gesundheitsrelevante_Analyseergebnisse', 'MII', 2000, NULL, NULL, '', '0c32e855-de13-45ed-85e8-779ca3ddf00c'),
	('Rekontaktierung_Zusatzbefund', 'MII', 1000, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', 'dc2191bc-9c35-4d7a-9f54-53a493e2f690'),
	('Rekontaktierung_Zusatzbefund', 'MII', 1000, 'Rekontaktierung_Zusatzbefund', 'MII', 1008, NULL, NULL, '', '2c0c9dd2-819c-48d3-82dc-fcd329cc8ae6'),
	('Rekontaktierung_weitere_Erhebung', 'MII', 1001, 'Kontaktsperre_Informationen_wissenschaftliche_Fragen_neue_Studien', 'MII', 2000, NULL, NULL, '', 'f1c91cce-7cf4-4376-9067-4f1cd3178650'),
	('Rekontaktierung_weitere_Erhebung', 'MII', 1001, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '464c2c6e-4f25-4624-99d3-05ef1dd497a8'),
	('Rekontaktierung_weitere_Erhebung', 'MII', 1001, 'Rekontaktierung_Ergaenzungen', 'MII', 1007, NULL, NULL, '', '4a2179c3-7eab-4e6c-b356-c5f9d1ca15c5'),
	('Rekontaktierung_weitere_Studien', 'MII', 1001, 'Kontaktsperre_Informationen_wissenschaftliche_Fragen_neue_Studien', 'MII', 2000, NULL, NULL, '', 'a1572f58-5db5-404d-85b1-c416c453f4ba'),
	('Rekontaktierung_weitere_Studien', 'MII', 1001, 'PATDAT_BIOMAT_KKDAT_komplett_widerrufen', 'MII', 2000, NULL, NULL, '', '0ef4e7d0-2e9a-42e6-af1e-e835d8805d02'),
	('Rekontaktierung_weitere_Studien', 'MII', 1001, 'Rekontaktierung_Ergaenzungen', 'MII', 1007, NULL, NULL, '', 'f64975c8-3194-4e7d-9b7e-d602252353f0'),
	('Share Biomaterial', 'Demo EU', 1000, 'Biomaterial', 'Demo EU', 1000, NULL, NULL, '', '540d5500-02ec-44a2-b914-8c878cb1f808'),
	('Share Medical Data', 'Demo EU', 1000, 'Privacy Statement', 'Demo EU', 1000, NULL, NULL, '', 'faed916d-6d56-4953-ada9-7372a348eb35'),
	('Store Biomaterial', 'Demo EU', 1000, 'Biomaterial', 'Demo EU', 1000, NULL, NULL, '', 'f0a9a806-f4ba-41f3-a4e1-e6412bf49c3f'),
	('Store Identifying Data', 'Demo EU', 1000, 'Privacy Statement', 'Demo EU', 1000, NULL, NULL, '', '40add13b-6941-480f-8a96-3132de73eccf'),
	('Store Medical Data', 'Demo EU', 1000, 'Privacy Statement', 'Demo EU', 1000, NULL, NULL, '', 'bb2ba1ec-9c58-475e-9ac2-e9282f2c760f');

-- Exportiere Daten aus Tabelle gics.policy: ~45 rows (ungefähr)
INSERT IGNORE INTO `policy` (`COMMENT`, `EXTERN_PROPERTIES`, `NAME`, `VERSION`, `DOMAIN_NAME`, `CREATE_TIMESTAMP`, `UPDATE_TIMESTAMP`, `LABEL`, `FINALISED`, `FHIR_ID`) VALUES
	('Zusammenführen von auf Biomaterialien (BIOMAT) basierenden Analysedaten mit Analysedaten Dritter, sofern dort ebenfalls eine Einwilligung vorliegt', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.23', 'BIOMAT_Analysedaten_zusammenfuehren_Dritte', 1001, 'MII', '2022-02-01 09:13:28.042', '2022-02-01 09:49:16.063', 'BIOMAT_Analysedaten_zusammenfuehren_Dritte', 1, 'd658431f-b5fd-42b8-bc01-4535c06b9a14'),
	('Eigentumsübertragung der BIOMAT an den Träger der Biobank', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.21', 'BIOMAT_Eigentum_uebertragen', 1000, 'MII', '2022-02-01 09:13:27.975', '2022-02-01 09:49:16.061', 'BIOMAT_Eigentum_uebertragen', 1, '92e4a9de-c74e-473e-89e7-f98ab4ba45e8'),
	('Entnahme zusätzlicher Mengen von Biomaterialien (BIOMAT) in den in der Einwilligung beschriebenen Grenzen', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.25', 'BIOMAT_Zusatzmengen_entnehmen', 1000, 'MII', '2022-02-01 09:13:28.223', '2022-02-01 09:49:16.068', 'BIOMAT_Zusatzmengen_entnehmen', 1, '4f25a81d-55e3-4f07-a13d-5156038761c6'),
	('Gewinnung von Biomaterialien (BIOMAT)', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.19', 'BIOMAT_erheben', 1001, 'MII', '2022-02-01 09:13:28.033', '2022-02-01 09:49:16.062', 'BIOMAT_erheben', 1, '4cc1f14f-9520-4b37-8460-91e8a252ee3d'),
	('Lagerung und Verarbeitung von Biomaterialien innerhalb der verantwortlichen Stelle (BIOMAT)', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.20', 'BIOMAT_lagern_verarbeiten', 1000, 'MII', '2022-02-01 09:13:28.028', '2022-02-01 09:49:16.062', 'BIOMAT_lagern_verarbeiten', 1, 'b2755b89-540c-4ea9-853b-d5435737ff50'),
	('Bereitstellung umcodierter Biomaterialien (BIOMAT)  für wissenschaftliche Nutzung  und Analysen zu Zwecken med. Forschung an ext. Forscher', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.22', 'BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, 'MII', '2022-02-01 09:13:28.022', '2022-02-01 09:49:16.062', 'BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_NIVEAU', 1, '3c7077e0-959e-4bef-b86d-8d8710f47945'),
	('Abnahme von Biomaterial', '', 'Biomaterial erheben', 1000, 'Demo Deutschland', '2022-02-01 09:15:26.333', '2022-02-01 09:16:12.568', 'Biomaterial erheben', 1, 'c9cb37de-d3bd-4399-abd1-adf9c0045d5f'),
	('Herausgabe von Biomaterial', '', 'Biomaterial herausgeben', 1000, 'Demo Deutschland', '2022-02-01 09:15:26.341', '2022-02-01 09:16:12.569', 'Biomaterial herausgeben', 1, '68e22150-c4f2-4c22-8cb3-a49111c5d4cc'),
	('Aufbewahrung von Biomaterial', '', 'Biomaterial lagern', 1000, 'Demo Deutschland', '2022-02-01 09:15:26.337', '2022-02-01 09:16:12.568', 'Biomaterial lagern', 1, 'b500683c-fbaf-4826-a4b8-7d00183ed47e'),
	('', '', 'Collect Biomaterial', 1000, 'Demo EU', '2022-02-01 09:15:40.654', '2022-02-01 09:20:22.665', 'Collect Biomaterial', 1, '90ac6221-fa91-4e64-bb39-7856a6c6c17c'),
	('', '', 'Collect Identifying Data', 1000, 'Demo EU', '2022-02-01 09:15:40.661', '2022-02-01 09:20:22.664', 'Collect Identifying Data', 1, '94245921-0792-4824-b1dd-f7022f35a7d9'),
	('', '', 'Collect Medical Data', 1000, 'Demo EU', '2022-02-01 09:15:40.668', '2022-02-01 09:20:22.664', 'Collect Medical Data', 1, '799da392-e9c3-4628-9c38-1f94ce3b4a89'),
	('Herausgabe identifizierender Daten (IDAT) an unabhängige Treuhandstelle zur weiteren Verarbeitung', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.5', 'IDAT_bereitstellen_EU_DSGVO_konform', 1001, 'MII', '2022-02-01 09:13:28.138', '2022-02-01 09:49:16.065', 'IDAT_bereitstellen_EU_DSGVO_NIVEAU', 1, '7d54b85f-6a48-4bc3-aaf6-79790fecbb2c'),
	('Erfassung neuer identifizierender Daten (IDAT)', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.2', 'IDAT_erheben', 1000, 'MII', '2022-02-01 09:13:28.178', '2022-02-01 09:49:16.067', 'IDAT_erheben', 1, '3905f634-a44d-4788-94d2-be8d1309a19a'),
	('Speicherung und Verarbeitung identifizierender Daten (IDAT) zu Zwecken med. Forschung in der verantwortlichen Stelle', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.3', 'IDAT_speichern_verarbeiten', 1000, 'MII', '2022-02-01 09:13:28.154', '2022-02-01 09:49:16.066', 'IDAT_speichern_verarbeiten', 1, '53adbbe0-62d9-4d06-aacf-d255ae1079d1'),
	('Zusammenführung identifizierender Daten (IDAT) über die unabhängige Treuhandstelle mit Dritten Forschungspartnern, sofern dort eine Einwilligung vorliegt', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.4', 'IDAT_zusammenfuehren_Dritte', 1000, 'MII', '2022-02-01 09:13:28.184', '2022-02-01 09:49:16.067', 'IDAT_zusammenfuehren_Dritte', 1, 'e03ef2b7-9959-4269-ae0c-35a2cfea1f67'),
	('Erfassung neuer identifizierender Daten', '', 'Identifizierende Daten erheben', 1000, 'Demo Deutschland', '2022-02-01 09:15:26.326', '2022-02-01 09:16:12.561', 'Identifizierende Daten erheben', 1, '86e1913a-b477-44b5-85a4-c470a3f53463'),
	('Speicherung identifizierender Daten', '', 'Identifizierende Daten speichern', 1000, 'Demo Deutschland', '2022-02-01 09:15:26.330', '2022-02-01 09:16:12.561', 'Identifizierende Daten speichern', 1, '54012770-4d9e-4ebe-95b0-824a589a6649'),
	('Prospektive Krankenkassendaten (KKDAT) aus fünf Jahren ab Einwilligung speichern und codiert verarbeiten zu Zwecken der med. Forschung in der verantwortlichen Stelle', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.16', 'KKDAT_5J_pro_speichern_verarbeiten', 1000, 'MII', '2022-02-01 09:13:28.199', '2022-02-01 09:49:16.068', 'KKDAT_5J_pro_speichern_verarbeiten', 1, '50152cc1-33b3-414a-8393-2d6c25a2ec48'),
	('Prospektive Krankenkassendaten (KKDAT) für fünf Kalenderjahre nach Datum Unterschrift übertragen', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.15', 'KKDAT_5J_pro_uebertragen', 1000, 'MII', '2022-02-01 09:13:28.189', '2022-02-01 09:49:16.067', 'KKDAT_5J_pro_uebertragen', 1, 'e7bf9038-c27c-4650-88f3-131575c7301d'),
	('Bereitstellung umcodierter prospektiver Krankenkassendaten (KKDAT) aus fünf Jahren ab Einwilligung zu Zwecken med. Forschung an ext. Forscher', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.17', 'KKDAT_5J_pro_wissenschaftlich_nutzen', 1000, 'MII', '2022-02-01 09:13:28.205', '2022-02-01 09:49:16.068', 'KKDAT_5J_pro_wissenschaftlich_nutzen', 1, '7464730a-9e8c-4132-8d59-cd247768d230'),
	('Retrospektive Krankenkassendaten (KKDAT) aus fünf Jahren vor Einwilligung speichern und codiert verarbeiten zu Zwecken med. Forschung in der verantwortlichen Stelle', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.12', 'KKDAT_5J_retro_speichern_verarbeiten', 1001, 'MII', '2022-02-01 09:13:28.113', '2022-02-01 09:49:16.064', 'KKDAT_5J_retro_speichern_verarbeiten', 1, '165e44d0-ac09-4d0f-8f6f-7b2b1af1d98d'),
	('Krankenkassendaten (KKDAT) der letzten fünf Kalenderjahre vor Datum Unterschrift übertragen', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.11', 'KKDAT_5J_retro_uebertragen', 1000, 'MII', '2022-02-01 09:13:28.094', '2022-02-01 09:49:16.064', 'KKDAT_5J_retro_uebertragen', 1, '5b04876d-8a25-4773-9722-e4adee2d5318'),
	('Bereitstellung umcodierter retrospektiver Krankenkassendaten (KKDAT) für wissenschaftliche Nutzung zu Zwecken med. Forschung an externe Forscher', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.13', 'KKDAT_5J_retro_wissenschaftlich_nutzen', 1000, 'MII', '2022-02-01 09:13:28.067', '2022-02-01 09:49:16.064', 'KKDAT_5J_retro_wissenschaftlich_nutzen', 1, '7424d267-2690-45a4-9e64-87ae2b8656a9'),
	('Erlaubnis zur prospektiven Übermittlung der KVNr., MII-Pseudonym und Zeitraum Datenübermittlung (von: Datum Unterschrift; bis: max. 5 Kalenderjahre nach Unterschrift) an zuständige Stelle', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.39', 'KKDAT_KVNR_5J_pro_uebertragen', 1000, 'MII', '2022-02-01 09:13:28.194', '2022-02-01 09:49:16.067', 'KKDAT_5J_pro_uebertragen_KVNR', 1, 'd60a5c41-40b9-4ff7-9962-4030ae785219'),
	('Erlaubnis zur retrospektiven Übermittlung der KVNr., MII-Pseudonym und Zeitraum Datenübermittlung (von:5 Jahre vor Datum Unterschrift; bis: Datum Unterschrift) an zuständige Stelle', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.38', 'KKDAT_KVNR_5J_retro_uebertragen', 1000, 'MII', '2022-02-01 09:13:28.072', '2022-02-01 09:49:16.064', 'KKDAT_5J_retro_uebertragen_KVNR', 1, 'c967f628-8896-4964-8969-f0fd48780147'),
	('Erfassung medizinischer Daten (MDAT)', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.6', 'MDAT_erheben', 1001, 'MII', '2022-02-01 09:13:28.145', '2022-02-01 09:49:16.065', 'MDAT_erheben', 1, '657e9718-fb00-4c62-8fea-1ebbcaf04c71'),
	('Speicherung und Verarbeitung von medizinischen codierten Daten zu Zwecken med. Forschung innerhalb der verantwortlichen Stelle (MDAT)', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.7', 'MDAT_speichern_verarbeiten', 1000, 'MII', '2022-02-01 09:13:28.127', '2022-02-01 09:49:16.064', 'MDAT_speichern_verarbeiten', 1, '01932f12-2a23-4fe7-8a40-abcb35e07c54'),
	('Bereitstellung umcodierter medizinischer Daten (MDAT) für wissenschaftliche Nutzung zu Zwecken med. Forschung an externe Forscher', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.8', 'MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, 'MII', '2022-02-01 09:13:28.168', '2022-02-01 09:49:16.066', 'MDAT_wissenschaftlich_nutzen_EU_DSGVO_NIVEAU', 1, '9929f64a-0db7-4a44-a32c-cb9695c6e59b'),
	('Zusammenführung medizinischer Daten (MDAT) mit Dritten Forschungspartnern, sofern dort eine Einwilligung vorliegt', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.9', 'MDAT_zusammenfuehren_Dritte', 1000, 'MII', '2022-02-01 09:13:28.162', '2022-02-01 09:49:16.066', 'MDAT_zusammenfuehren_Dritte', 1, '98ddbcb6-da88-4743-9988-ac6d6b86dde0'),
	('Erfassung neuer medizinischer Daten', '', 'Medizinische Daten erheben', 1000, 'Demo Deutschland', '2022-02-01 09:15:26.316', '2022-02-01 09:16:12.562', 'Medizinische Daten erheben', 1, '0badfe2f-d359-4f3b-b620-5caeca10d100'),
	('Herausgabe medizinischer Daten', '', 'Medizinische Daten herausgeben', 1000, 'Demo Deutschland', '2022-02-01 09:15:26.319', '2022-02-01 09:16:12.562', 'Medizinische Daten herausgeben', 1, 'bd963d0a-d4c7-4055-a343-7d76064833b5'),
	('Speicherung medizinischer Daten', '', 'Medizinische Daten speichern', 1000, 'Demo Deutschland', '2022-02-01 09:15:26.322', '2022-02-01 09:16:12.562', 'Medizinische Daten speichern', 1, '500a362c-675e-49fe-993c-b7ca6fc81e18'),
	('', '', 'Recontact Follow Up Study', 1000, 'Demo EU', '2022-02-01 09:15:40.677', '2022-02-01 09:20:22.665', 'Recontact Follow Up Study', 1, '6fa36ac5-c317-487b-8c97-b76d3c072b4a'),
	('Kontaktierung für Einladung zur Folgestudie', '', 'Rekontaktierung Folgestudie', 1000, 'Demo Deutschland', '2022-02-01 09:15:26.344', '2022-02-01 09:16:12.562', 'Rekontaktierung Folgestudie', 1, '677fa3dc-4d76-478e-8f3c-6a04e20962f5'),
	('Rekontaktierung des Betroffenen bei Ergebnissen von erheblicher Bedeutung', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.37', 'Rekontaktierung_Ergebnisse_erheblicher_Bedeutung', 1000, 'MII', '2022-02-01 09:13:28.173', '2022-02-01 09:49:16.067', 'Rekontaktierung_Ergebnisse_erheblicher_Bedeutung', 1, 'abaf03a9-d829-4674-bbb2-bf746f734c66'),
	('Rekontaktierung zur Verknüpfung von Patientendaten mit Daten anderer Datenbanken', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.27', 'Rekontaktierung_Verknuepfung_Datenbanken', 1000, 'MII', '2022-02-01 09:13:28.047', '2022-02-01 09:49:16.063', 'Rekontaktierung_Verknuepfung_Datenbanken', 1, '25f7074e-852e-4a86-bb7f-70e835d93020'),
	('Rekontaktierung bezüglich Zusatzbefund im Rahmen der am Standort dafür entwickelten Prozesse und der im Nutzungsantrag angegebenen Bedingungen', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.31', 'Rekontaktierung_Zusatzbefund', 1000, 'MII', '2022-02-01 09:13:28.211', '2022-02-01 09:49:16.068', 'Rekontaktierung_Zusatzbefund', 1, '3830251b-424c-443f-93ea-53d9498b5344'),
	('Rekontaktierung bezüglich Erhebung zusätzlicher Daten', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.28', 'Rekontaktierung_weitere_Erhebung', 1001, 'MII', '2022-02-01 09:13:28.061', '2022-02-01 09:49:16.063', 'Rekontaktierung_weitere_Erhebung', 1, 'e654c332-6216-4283-9f47-a610620c67a8'),
	('Rekontaktierung bezüglich Information zu neuen Forschungsvorhaben oder Studien', 'fhirPolicyCode=2.16.840.1.113883.3.1937.777.24.5.3.29', 'Rekontaktierung_weitere_Studien', 1001, 'MII', '2022-02-01 09:13:28.055', '2022-02-01 09:49:16.063', 'Rekontaktierung_weitere_Studien', 1, '76a49a12-7fab-46c0-af3a-44e261290ee1'),
	('', '', 'Share Biomaterial', 1000, 'Demo EU', '2022-02-01 09:15:40.647', '2022-02-01 09:20:22.665', 'Share Biomaterial', 1, '918108a3-26dc-44a9-8668-31d477f0f632'),
	('', '', 'Share Medical Data', 1000, 'Demo EU', '2022-02-01 09:15:40.672', '2022-02-01 09:20:22.664', 'Share Medical Data', 1, 'b9090d53-10fa-4e07-aad5-554bd771941a'),
	('', '', 'Store Biomaterial', 1000, 'Demo EU', '2022-02-01 09:15:40.650', '2022-02-01 09:20:22.665', 'Store Biomaterial', 1, 'e9901f7e-11a8-4d64-84bc-8ab6afc5e5a6'),
	('', '', 'Store Identifying Data', 1000, 'Demo EU', '2022-02-01 09:15:40.658', '2022-02-01 09:20:22.664', 'Store Identifying Data', 1, 'e07d1240-1bf1-45f0-bf68-dadd4e6d225c'),
	('', '', 'Store Medical Data', 1000, 'Demo EU', '2022-02-01 09:15:40.665', '2022-02-01 09:20:22.664', 'Store Medical Data', 1, '75ed7cde-9534-43ae-9e52-d645e3f84d97');

-- Exportiere Daten aus Tabelle gics.qc: ~12 rows (ungefähr)
INSERT IGNORE INTO `qc` (`COMMENT`, `TIMESTAMP`, `EXTERN_PROPERTIES`, `INSPECTOR`, `VIRTUAL_PERSON_ID`, `TYPE`, `CT_VERSION`, `CT_DOMAIN_NAME`, `CONSENT_DATE`, `CT_NAME`, `FHIR_ID`) VALUES
	('Kleiner Fehler bei Lorem Ipsum.', '2022-02-01 09:18:28.053', NULL, 'Mitarbeiter#1', 1, 'checked_minor_faults', 1000, 'Demo Deutschland', '2022-02-01 09:16:49.093', 'Einwilligung Demostudie', '17ae3742-8dc1-418d-8705-56b0ec603679'),
	('Passt.', '2022-02-01 09:18:11.144', NULL, 'Mitarbeiter#1', 2, 'checked_no_faults', 1000, 'Demo Deutschland', '2022-02-01 09:17:38.235', 'Einwilligung Demostudie', 'e391a973-971b-4101-b56d-9965dba21119'),
	('', '2022-02-01 09:19:48.555', NULL, 'M', 1, 'checked_no_faults', 1000, 'Demo Deutschland', '2022-02-01 09:19:30.733', 'Widerruf Datenerhebung', '5207b9eb-d0f7-4623-a625-bd9d76338631'),
	('', '2022-02-01 09:21:16.360', NULL, '', 3, 'not_checked', 1000, 'Demo EU', '2022-02-01 09:21:16.346', 'Consent Demostudy', '790183d9-9b7f-4804-a151-f5f64941d2b7'),
	('', '2022-02-01 09:22:33.395', NULL, '', 4, 'not_checked', 1000, 'Demo EU', '2022-02-01 09:22:33.371', 'Consent Demostudy', '74ab0a3e-01f7-4135-9f68-ea08a70b10cd'),
	('', '2022-02-01 09:23:23.768', NULL, '', 3, 'not_checked', 1000, 'Demo EU', '2022-02-01 09:23:23.758', 'Withdrawal Data Collection', 'e49cd085-1ea6-46fe-a1ff-bc4300db541f'),
	('Keine Anpassungen erforderlich.', '2022-02-01 09:27:59.820', NULL, 'Mitarbeiter#1', 5, 'checked_no_faults', 1006003, 'MII', '2022-02-01 09:27:24.146', 'Patienteneinwilligung MII', 'f78ffb7c-52cb-4b34-8087-496ebb07b71a'),
	('', '2022-02-01 09:30:19.387', NULL, '', 6, 'not_checked', 1006003, 'MII', '2022-02-01 09:30:19.377', 'Patienteneinwilligung MII', 'cf54f131-4597-4034-beb5-71791801272a'),
	('', '2022-02-01 09:31:40.655', NULL, '', 7, 'not_checked', 1006003, 'MII', '2022-02-01 09:31:40.632', 'Patienteneinwilligung MII', 'c484efbc-dfd9-43a7-9de6-9b0bb4f3bf3c'),
	('Passt.', '2022-02-01 09:33:54.524', NULL, 'Mitarbeiter#1', 7, 'checked_no_faults', 2000000, 'MII', '2022-02-01 09:32:36.448', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', '97bb0b3b-aca4-4fc8-8288-ee0bda044ce1'),
	('Passt.', '2022-02-01 09:34:13.220', NULL, 'Mitarbeiter#1', 7, 'checked_minor_faults', 2000000, 'MII', '2022-02-01 09:33:28.627', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 'c1ea6a3f-0177-4b07-87e0-646d3d20590d'),
	('', '2022-02-01 09:55:08.246', NULL, '', 8, 'not_checked', 1006003, 'MII', '2022-02-01 09:55:08.225', 'Patienteneinwilligung MII', '1301ae26-0937-4d44-8467-70f6b8817106');

-- Exportiere Daten aus Tabelle gics.qc_hist: ~18 rows (ungefähr)
INSERT IGNORE INTO `qc_hist` (`COMMENT`, `TIMESTAMP`, `EXTERN_PROPERTIES`, `INSPECTOR`, `VIRTUAL_PERSON_ID`, `TYPE`, `CT_VERSION`, `CT_DOMAIN_NAME`, `CONSENT_DATE`, `CT_NAME`, `START_DATE`, `END_DATE`, `FHIR_ID`) VALUES
	('', '2022-02-01 09:16:49.182', NULL, '', 1, 'not_checked', 1000, 'Demo Deutschland', '2022-02-01 09:16:49.093', 'Einwilligung Demostudie', '2022-02-01 09:16:49.263', '2022-02-01 09:18:28.084', '17ae3742-8dc1-418d-8705-56b0ec603679'),
	('Kleiner Fehler bei Lorem Ipsum.', '2022-02-01 09:18:28.053', NULL, 'Mitarbeiter#1', 1, 'checked_minor_faults', 1000, 'Demo Deutschland', '2022-02-01 09:16:49.093', 'Einwilligung Demostudie', '2022-02-01 09:18:28.084', NULL, '17ae3742-8dc1-418d-8705-56b0ec603679'),
	('', '2022-02-01 09:17:38.248', NULL, '', 2, 'not_checked', 1000, 'Demo Deutschland', '2022-02-01 09:17:38.235', 'Einwilligung Demostudie', '2022-02-01 09:17:38.266', '2022-02-01 09:18:11.154', 'e391a973-971b-4101-b56d-9965dba21119'),
	('Passt.', '2022-02-01 09:18:11.144', NULL, 'Mitarbeiter#1', 2, 'checked_no_faults', 1000, 'Demo Deutschland', '2022-02-01 09:17:38.235', 'Einwilligung Demostudie', '2022-02-01 09:18:11.154', NULL, 'e391a973-971b-4101-b56d-9965dba21119'),
	('', '2022-02-01 09:19:30.761', NULL, '', 1, 'not_checked', 1000, 'Demo Deutschland', '2022-02-01 09:19:30.733', 'Widerruf Datenerhebung', '2022-02-01 09:19:30.775', '2022-02-01 09:19:48.561', '5207b9eb-d0f7-4623-a625-bd9d76338631'),
	('', '2022-02-01 09:19:48.555', NULL, 'M', 1, 'checked_no_faults', 1000, 'Demo Deutschland', '2022-02-01 09:19:30.733', 'Widerruf Datenerhebung', '2022-02-01 09:19:48.561', NULL, '5207b9eb-d0f7-4623-a625-bd9d76338631'),
	('', '2022-02-01 09:21:16.360', NULL, '', 3, 'not_checked', 1000, 'Demo EU', '2022-02-01 09:21:16.346', 'Consent Demostudy', '2022-02-01 09:21:16.374', NULL, '790183d9-9b7f-4804-a151-f5f64941d2b7'),
	('', '2022-02-01 09:22:33.395', NULL, '', 4, 'not_checked', 1000, 'Demo EU', '2022-02-01 09:22:33.371', 'Consent Demostudy', '2022-02-01 09:22:33.406', NULL, '74ab0a3e-01f7-4135-9f68-ea08a70b10cd'),
	('', '2022-02-01 09:23:23.768', NULL, '', 3, 'not_checked', 1000, 'Demo EU', '2022-02-01 09:23:23.758', 'Withdrawal Data Collection', '2022-02-01 09:23:23.778', NULL, 'e49cd085-1ea6-46fe-a1ff-bc4300db541f'),
	('', '2022-02-01 09:27:24.174', NULL, '', 5, 'not_checked', 1006003, 'MII', '2022-02-01 09:27:24.146', 'Patienteneinwilligung MII', '2022-02-01 09:27:24.215', '2022-02-01 09:27:59.825', 'f78ffb7c-52cb-4b34-8087-496ebb07b71a'),
	('Keine Anpassungen erforderlich.', '2022-02-01 09:27:59.820', NULL, 'Mitarbeiter#1', 5, 'checked_no_faults', 1006003, 'MII', '2022-02-01 09:27:24.146', 'Patienteneinwilligung MII', '2022-02-01 09:27:59.825', NULL, 'f78ffb7c-52cb-4b34-8087-496ebb07b71a'),
	('', '2022-02-01 09:30:19.387', NULL, '', 6, 'not_checked', 1006003, 'MII', '2022-02-01 09:30:19.377', 'Patienteneinwilligung MII', '2022-02-01 09:30:19.401', NULL, 'cf54f131-4597-4034-beb5-71791801272a'),
	('', '2022-02-01 09:31:40.655', NULL, '', 7, 'not_checked', 1006003, 'MII', '2022-02-01 09:31:40.632', 'Patienteneinwilligung MII', '2022-02-01 09:31:40.663', NULL, 'c484efbc-dfd9-43a7-9de6-9b0bb4f3bf3c'),
	('', '2022-02-01 09:32:36.489', NULL, '', 7, 'not_checked', 2000000, 'MII', '2022-02-01 09:32:36.448', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', '2022-02-01 09:32:36.519', '2022-02-01 09:33:54.527', '97bb0b3b-aca4-4fc8-8288-ee0bda044ce1'),
	('Passt.', '2022-02-01 09:33:54.524', NULL, 'Mitarbeiter#1', 7, 'checked_no_faults', 2000000, 'MII', '2022-02-01 09:32:36.448', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', '2022-02-01 09:33:54.527', NULL, '97bb0b3b-aca4-4fc8-8288-ee0bda044ce1'),
	('', '2022-02-01 09:33:28.639', NULL, '', 7, 'not_checked', 2000000, 'MII', '2022-02-01 09:33:28.627', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', '2022-02-01 09:33:28.689', '2022-02-01 09:34:13.229', 'c1ea6a3f-0177-4b07-87e0-646d3d20590d'),
	('Passt.', '2022-02-01 09:34:13.220', NULL, 'Mitarbeiter#1', 7, 'checked_minor_faults', 2000000, 'MII', '2022-02-01 09:33:28.627', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', '2022-02-01 09:34:13.229', NULL, 'c1ea6a3f-0177-4b07-87e0-646d3d20590d'),
	('', '2022-02-01 09:55:08.246', NULL, '', 8, 'not_checked', 1006003, 'MII', '2022-02-01 09:55:08.225', 'Patienteneinwilligung MII', '2022-02-01 09:55:08.292', NULL, '1301ae26-0937-4d44-8467-70f6b8817106');

-- Exportiere Daten aus Tabelle gics.qc_problem: ~0 rows (ungefähr)

-- Exportiere Daten aus Tabelle gics.qc_problem_hist: ~0 rows (ungefähr)

-- Exportiere Daten aus Tabelle gics.sequence: ~0 rows (ungefähr)
INSERT IGNORE INTO `sequence` (`SEQ_NAME`, `SEQ_COUNT`) VALUES
	('statistic_index', 3),
	('virtual_person_index', 8);

-- Exportiere Daten aus Tabelle gics.signature: ~24 rows (ungefähr)
INSERT IGNORE INTO `signature` (`SIGNATUREDATE`, `SIGNATUREPLACE`, `SIGNATURESCANBASE64`, `TYPE`, `IDENTIFIERS`, `CONSENT_DATE`, `CONSENT_VIRTUAL_PERSON_ID`, `CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`, `FHIR_ID`) VALUES
	('2022-01-31 23:00:00.000', 'Greifswald', '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', 'guardian', NULL, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, '5954cc10-16a6-4ca8-a908-2868902c83b5'),
	('2022-01-31 23:00:00.000', 'Greifswald', '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', 'guardian', NULL, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, '13acd409-599b-4e7d-87ef-7a981e769bf0'),
	('2022-01-31 23:00:00.000', 'Greifswald', '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', 'participant', NULL, '2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'e00c210c-4426-4d44-96fa-35aad5ddf7e1'),
	('2022-01-31 23:00:00.000', 'Greifswald', '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', 'participant', NULL, '2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, '78165e35-b922-4f97-9740-c90cbf763046'),
	('2022-01-31 23:00:00.000', '', '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', 'participant', NULL, '2022-02-01 09:19:30.733', 1, 'Demo Deutschland', 'Widerruf Datenerhebung', 1000, '774b2112-05ff-4ff4-9ff9-ae38b94c93eb'),
	('2022-01-31 23:00:00.000', 'Paris', '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', 'participant', NULL, '2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, '92300d97-d976-40d3-a569-86f623889d1b'),
	('2022-01-31 23:00:00.000', 'Wien', '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', 'participant', NULL, '2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, '2bf58816-ac36-47c3-829c-df1515cdfb4c'),
	('2022-01-31 23:00:00.000', 'Paris', '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', 'participant', NULL, '2022-02-01 09:23:23.758', 3, 'Demo EU', 'Withdrawal Data Collection', 1000, 'c4ab0cd2-a1d9-47c7-a6c4-a2051ce4e6cf'),
	('2022-01-31 23:00:00.000', 'Greifswald', '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', 'participant', NULL, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, '30d1db0c-17fd-4017-903d-ec79a66fda87'),
	('2022-01-31 23:00:00.000', 'Greifswald', NULL, 'participant', NULL, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, '7986b6ad-5ef4-47c9-aed5-0a225c2ee68d'),
	('2022-01-31 23:00:00.000', 'Greifswald', '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', 'participant', NULL, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'd71c5a31-64fc-49cd-beb3-774b423963c7'),
	('2022-01-31 23:00:00.000', 'Greifswald', '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', 'participant', NULL, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'e000bb3b-e639-4dfc-944a-d2a21fffa1f4'),
	('2022-01-31 23:00:00.000', 'Erlangen', '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', 'physician', '{"physician_id":"Dr. Strange"}', '2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, '1fd7c359-130d-4048-8ca9-e9411807ab49'),
	('2022-01-31 23:00:00.000', 'Erlangen', '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', 'physician', '{"physician_id":"Dr. Banner"}', '2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, '5757dc94-679c-491c-a057-ba7e7ce41393'),
	(NULL, NULL, NULL, 'physician', NULL, '2022-02-01 09:19:30.733', 1, 'Demo Deutschland', 'Widerruf Datenerhebung', 1000, 'a081a41a-a84e-412c-9358-01516d855531'),
	('2022-01-31 23:00:00.000', 'Paris', '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', 'physician', '{"physician_id":"Dr. LeStrange"}', '2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, 'b72a6475-f488-4b78-b213-4752a8d691bb'),
	('2022-01-31 23:00:00.000', 'Wien', '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', 'physician', '{"physician_id":"Dr. Adler"}', '2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, '835f7061-ddbd-4181-bb8c-55a81e2099f8'),
	(NULL, NULL, NULL, 'physician', NULL, '2022-02-01 09:23:23.758', 3, 'Demo EU', 'Withdrawal Data Collection', 1000, '3da78d39-98e9-4517-a216-37e2f5c817bd'),
	('2022-01-31 23:00:00.000', 'Erlangen', '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', 'physician', '{"physician_id":"Dr. Strange"}', '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'd9674894-7104-46c3-8386-a8da7a8ba21e'),
	('2022-01-31 23:00:00.000', 'Erlangen', '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', 'physician', '{"physician_id":"Dr. Strange"}', '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, '19972ffc-26fb-4fd7-a23f-1f4f923ea4ce'),
	('2022-01-31 23:00:00.000', 'Erlangen', 'iVBORw0KGgoAAAANSUhEUgAAAfQAAACWCAYAAAAonXpvAAASfElEQVR4Xu3daXCV1R3H8X/2QMgGYQkQICD7JiJUHHGsOo4z2upIp+1MpzMu7RudsTPFaacvWnW62O1NtdLWvuiLjkvtMlVhRkeRVihUUYqg7FvCHgKBEJYEkvT/f+69SQi5OYHcJPecfM/M9d7w3Nx7zuc84y/nPM9znoxWLUJBAAEEEEAAAa8FMgh0r/uPyiOAAAIIIBAJEOjsCAgggAACCAQgQKAH0Ik0AQEEEEAAAQKdfQABBBBAAIEABAj0ADqRJiCAAAIIIECgsw8ggAACCCAQgACBHkAn0gQEEEAAAQQIdPYBBBBAAAEEAhAg0APoRJqAAAIIIIAAgc4+gAACCCCAQAACBHoAnUgTEEAAAQQQINDZBxBAAAEEEAhAgEAPoBNpAgIIIIAAAgQ6+wACCCCAAAIBCBDoAXQiTUAAAQQQQIBAZx9AAAEEEEAgAAECPYBOpAkIIIAAAggQ6OwDCCCAAAIIBCBAoAfQiTQBAQQQQAABAp19AAEEEEAAgQAECPQAOpEmIIAAAgggQKCzDyCAAAIIIBCAAIEeQCfSBAQQQAABBAh09gEEEEAAAQQCECDQA+hEmoAAAggggACBzj6AAAIIIIBAAAIEegCdSBMQQAABBBAg0NkHEEAAAQQQCECAQA+gE2kCAggggAACBDr7AAIIIIAAAgEIEOgBdCJNQAABBBBAgEBnH0AAAQQQQCAAAQI9gE6kCQgggAACCBDo7AMIIIAAAggEIECgB9CJNAEBBBBAAAECnX0AAQQQQACBAAQI9AA6kSYggAACCCBAoLMPIIAAAgggEIAAgR5AJ9IEBBBAAAEECHT2AQQQQAABBAIQINAD6ESagAACCCCAAIHOPoAAAggggEAAAgR6AJ1IExBAAAEEECDQ2QcQQAABBBAIQIBAD6ATaQICCCCAAAIEOvsAAggggAACAQgQ6AF0Ik1AAAEEEECAQGcfQAABBBBAIAABAj2ATqQJ/S9w6XKLnDp9UR8XpK6+UU7b42yj1J9tkvpzTXK2oUkazl+ScxcuyXl7XLwsF/XRcL5J39ckQ/KyJSNTpLXVHq3x59jrlhb9Ry1lw4fI8kcXyr23T+r/BvKNCCDgnQCB7l2XUeHeCjQ2NUuDhq4Fbuyhr88lXl+SMxrMBw7Vy+HjDXKkpkFOanBnZWZq0LZISzx8e1uHnv7+49+YL/agIIAAAi4BAt0lxPa0EbCRaxTAHcO4w+uzSUO6Y2A3yaVLLSlpU0aGSIb+JytTH1kZkp2VKTnZ+sjJkrzc2CM/LysajQ8dkiMF9hiarX8YiIzU0Xeuvi83N1Py7Dl6bc+xn23Uf9PsUTJxXFFK6sqHIIBA+AIEevh9nBYttCnnZEF85Qj5ytFyx9+xqetUFAvdbH2Izmw3XWqW5vgUd8fPHjViqFSUD5PJFSVir6dOKpHSonwpLc6TESX5UjQsNwpzCgIIIJAuAgR6uvREmtbDjhV3NyruaUg3N8eOC/emZOpIeNjQnNijILf99VB9XRD/9w6v83VkfOLUhWjqvOpwveyuOi1H9HXnUj6qQOZOK5M5+pg7bYTMmV4Wjap7W/ZVn5bN22tl+75Tsv/gGTmgdTAv+yPCXMeMLOAYeW+R+X0EEGgTINAH8c5gwXLw6NnoUX20IXresfeUfL77pE4RZ8vFRj2Rq7E5JUJD8rPjAdx1+A5LEsrRv0cBHpuy7q7s1QDduuukfLazVp9ro3Z0LvYZczS052poxwK8TEaXDb3mNtaduSjHa8/LMX1s210re6rPyKFjZ6M/IOr1hLgmPU7fkz9hOEZ+zfT8AgIIJBEg0APfNews60RoR8F9JBbg9jhSc87Zepuajo2KuwnieOB29z47vpzKUlt3QbZqcH+mAW7h/Zk+LEg7lxlThsdH3xriGt7TKkuvuRo2st+w6Yi8t75atuyo1aBulZ7MONiMfF5uthQX5sqo4UNlfHmhlJXmy/TK4TrN3yI3zxnNMfJr7g1+AQEEkgkQ6AHsG3a5VBTS8bCujge2/ZuNGJMVm8Ku0JCxx4T4c+LnYj1GbKNim7ZOp/LSX7bKS69tjWYPOpdUTJ0fOtYg72+olo1bj8uuA3VSoyNwmx7vrhToHzRlJUNk3JiC6Jj7TP0jYsGsUTJhbGE60VEXBBAIXIBA96SDazWYOwZ1bJo8NtK2a6CTFTvTOhHSXQW3T+d1/XTFh/Lqyp1RU/O1XfNnjryuqXM7Qe/AoTOyXy9N26Oj783ba/QYd72c0mn0xDXgnT3tLPaROsq+YWKJzNLAnqoj/crxRfoojs5mpyCAAAIDLUCgD3QPdPj+ozoFniy0z+nlWsmKTXV3Gdo6QizXE698L7v218mzL/xXPt1xImrK8scWyiPLZjubZce3E8GdeLbj7Hbsu7tix/vH6olyM6eMkFtuLJfF80frz8Oc38cbEEAAgYEUIND7Ud9WBWs/Ca39WHbi2LadpJaslBTlXTktrmGdmCYvKx3Sj63o368yk4UPvhKtoDZ1Uqk88+QtMn/GyLZK2HT4fh1t20Iw7c/1UZDb2fk9KRVjCqOR/tJFY2XJgrF6nDtcz5548B4EEPBTgEDvg36z47BVR+qlWi9TqtLj2tv1zPGtO0/osVhb4jP5uc+22EjbsWwN7I5T5MWFeX1Q0/T/yN+/ukV+++fNUUVtAZdRekZ6YoEZuy69G84uG2cn+dmCLTfpMW47zr1g1sho0RcKAggg4LsAgX6dPVhz8nx0xrgFt13jbMGdCPDuRto2dVvRYXRti5ckgptg6boz1nx4UH750sfR7Ma1FrtMbdG8MVFwW5BbiFMQQACBEAUI9G561db0rjrcKbTjAd7ddK5d1zxxbFF0SdJEC+/ouSgafefo0p6Ungls3HJMVm84KKv1crGjJ9ovsRs3ephOjZfLvOkjo6C2s/W7Kiyb2jNn3oUAAmEIDPpAv6BnPMdG2bHgToyy7bXdTStZKdVj2rHA1qCOB3fiZ1uUhXJ9AslC3GzvWjJB7rq14opj6Nf3LfwWAgggEJ7AoAh0WwQkMTXeeZr8WIeRX+futenaCeMKrxhtJ0LbTlKjpE7g3f9Uyfd+sfaKa74J8dT58kkIIBC+QJCBbtOziZHe2o2Ho7WzkxU7SSo2PX51cNtNOSj9I/DM8xvkb2/vlmL9Q2nZPVMZifcPO9+CAAIBCQQR6Lau9kdbjuvqXseiIN+r62p3LnbiWeKYdmKUbSE+Xi9Zogy8wE9e/FBeW7Uz6qM7Fo+XSbpoyyRdtKVSfy7Ts/8pCCCAAALdC3gZ6LbSlwW3PSzIt+258iYcttCKndm8aO7o6NlufZnqtcTZsVIr8PYHB+Spn3/Q5YfarUqjcLeQ14DvGPbRbVApCCCAAALiRaDbdcc2+o5G4Rrimz6vuaLr7H/qifBePHeM3KhnPlP8E7BV3GILxOjCMHopoC0OYz/bWvXJivW9HRqxe5z3ttihGVti19YDyMlpX861vqFRl9dt0j8Krz6b3q6Dt+Vz9V4r0tLaEq3M991HF8q9t0/qbXX4fQQQQOCaBNI20DdvPxEfhR+XjzTML3e6QYZdU7xIw3vRvNgo3BYduZ5in2treNuj7kxj/Fl/1jPcE/9m99O+oDcDadRbYqZ63e7LzS1SpPf2HqGrky29eWx0KZatWkZpFzipfZEI9/0dgt5CPx0Lt0RNx16hTgiEL5A2gb5j3ykNcA3v+FR65+u8Z90wIhbeGuKL9TnZIiw9Cej2AL/Y5S03B7rbbbQ5T5c3nTejTOZrwNszJ+hd3SvNOnNz6DoWm+lp/677+LA894eN0dvvuW2ifOXeqV3+qq0Nn7inul0jz/XvPRXmfQggkEqBAQt0m0qNwjs+lX5S72/dsUyeUCw2fW4jcbvDVYvObSYbQfcmoO0uWsOL86VUH/Yce50Xey5p/ze7Xn38mL65QYdNMdv9vbfozUe26D2+7Q5gnYtNLf/jxS9FZ+zPmDw8lfsAn9WFwDtrq2T5c/+Otjz80Gx56lsLcUIAAQTSWqBPA91OdPrBr9dF620360HGrMzYcU573XkNbjtpLT8vS/L0/tvZ+r78/Kwo5Lq7y1hXsj0N6ERop+Ma6bZC3ZYdtRruGvD6vGlbjdgfFFZWPHun3L5ofFrvVL5Xbqfe3W3ZE28R5r53JPVHYJAJ9Gmgr3j5U7FHb0oIAd2b9id+187kt4VumM5NhWb3n7FqzX75/q/Wik2fv/Onh/r+C/kGBBBAIAUCfRroVr/1m45cVU37H6Wr1NZd1Kn2YknHEbSr7mz3W+Cc3sVt6ddfjw5v/PWF+/W+6Bzi8LtHqT0Cg0OgzwN9cDDSytAEfva7j+SVt3bI1+6bLj984guhNY/2IIBAgAIEeoCdSpN6L7BLj6M/pMfR7dyOta99VQr10kIKAgggkM4CBHo69w51G1CBx59+Xz7YeEiWP7ZQHlk2e0DrwpcjgAACLgEC3SXE9kEr8L7ei/3JH6+Jlptd+ccHB60DDUcAAT8ECHQ/+olaDpDA/d/+Z7QM7d23TpDvPHxTtJ48BQEEEEhHAQI9HXuFOqWNwNO/2SB/f2d3W32WLhonD9w1hbXa06aHqAgCCCQECHT2BQQcAh9vPS5vrN4rb7y3V2/CoqskabGleB+4e4p8WcOdUTu7EAIIpIMAgZ4OvUAdvBA4e64pCvU3Ndy37TnFqN2LXqOSCAweAQJ98PQ1LU2hQFej9pycTLn/i5Plmw/MlGmVpSn8Nj4KAQQQcAsQ6G4j3oFAUoHEqP3lN3fIwQ53fls4Z7SGe6XcpwE/ND8bQQQQQKDPBQj0PifmCwaLwCef18iqNftkpa4Ff16Xj7ViC9Mkgn3JgvLBQkE7EUBgAAQI9AFA5yvDFmhubtVQ36fhvl/W/6/9XgaT9JI3m5K/745KqSgvDBuB1iGAQL8LEOj9Ts4XDiYBu4Y9MWrvOCW/9OZxOh1fGQU8BQEEEEiFAIGeCkU+A4EeCKz75HA0arfRe2vs6rdojfjElPyNM0f24FN4CwIIINC1AIHOnoFAPwvYiXSJYN+8/UTbt8+6YXh0Ep0F/IiSIf1cK74OAQR8FyDQfe9B6u+1wPa9p9qOt9fWXWhryz23TYym4+9cUuF1+6g8Agj0nwCB3n/WfBMC3Qq8u65KVv5rv6xeX932vqysDBk9okCe/9EdMmPycAQRQACBpAIEOjsHAmkmUHPyfHTp2+urdsqh4w1R7VY8e6fcvmh8mtWU6iCAQDoJEOjp1BvUBYFOAlV6lvxEvX0rBQEEEHAJEOguIbYjgAACCCDggQCB7kEnUUUEEEAAAQRcAgS6S4jtCCCAAAIIeCBAoHvQSVQRAQQQQAABlwCB7hJiOwIIIIAAAh4IEOgedBJVRAABBBBAwCVAoLuE2I4AAggggIAHAgS6B51EFRFAAAEEEHAJEOguIbYjgAACCCDggQCB7kEnUUUEEEAAAQRcAgS6S4jtCCCAAAIIeCBAoHvQSVQRAQQQQAABlwCB7hJiOwIIIIAAAh4IEOgedBJVRAABBBBAwCVAoLuE2I4AAggggIAHAgS6B51EFRFAAAEEEHAJEOguIbYjgAACCCDggQCB7kEnUUUEEEAAAQRcAgS6S4jtCCCAAAIIeCBAoHvQSVQRAQQQQAABlwCB7hJiOwIIIIAAAh4IEOgedBJVRAABBBBAwCVAoLuE2I4AAggggIAHAgS6B51EFRFAAAEEEHAJEOguIbYjgAACCCDggQCB7kEnUUUEEEAAAQRcAgS6S4jtCCCAAAIIeCBAoHvQSVQRAQQQQAABlwCB7hJiOwIIIIAAAh4IEOgedBJVRAABBBBAwCVAoLuE2I4AAggggIAHAgS6B51EFRFAAAEEEHAJEOguIbYjgAACCCDggQCB7kEnUUUEEEAAAQRcAgS6S4jtCCCAAAIIeCBAoHvQSVQRAQQQQAABlwCB7hJiOwIIIIAAAh4IEOgedBJVRAABBBBAwCVAoLuE2I4AAggggIAHAgS6B51EFRFAAAEEEHAJEOguIbYjgAACCCDggQCB7kEnUUUEEEAAAQRcAgS6S4jtCCCAAAIIeCBAoHvQSVQRAQQQQAABlwCB7hJiOwIIIIAAAh4IEOgedBJVRAABBBBAwCVAoLuE2I4AAggggIAHAgS6B51EFRFAAAEEEHAJEOguIbYjgAACCCDggQCB7kEnUUUEEEAAAQRcAgS6S4jtCCCAAAIIeCBAoHvQSVQRAQQQQAABlwCB7hJiOwIIIIAAAh4IEOgedBJVRAABBBBAwCVAoLuE2I4AAggggIAHAgS6B51EFRFAAAEEEHAJ/B+4dwC3d18s7wAAAABJRU5ErkJggg==', 'physician', '{"physician_id":"Dr. Banner"}', '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'a90c9f65-e16b-4082-b4c8-f4fe2424d0cc'),
	(NULL, NULL, NULL, 'physician', NULL, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, '177958ad-063a-4189-9cd5-0d0e44135d86'),
	(NULL, NULL, NULL, 'physician', NULL, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, '3ad60994-00ea-4b9b-8046-18f496526698'),
	('2022-01-31 23:00:00.000', 'Erlangen', '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', 'physician', '{"physician_id":"Dr. Strange"}', '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, '673ab7c0-c86c-4e58-91f8-2ddc57c2d599');

-- Exportiere Daten aus Tabelle gics.signed_policy: ~204 rows (ungefähr)
INSERT IGNORE INTO `signed_policy` (`STATUS`, `CONSENT_DATE`, `CONSENT_VIRTUAL_PERSON_ID`, `CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`, `POLICY_DOMAIN_NAME`, `POLICY_NAME`, `POLICY_VERSION`, `FHIR_ID`, `EXPIRATION_PROPERTIES`) VALUES
	(0, '2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Biomaterial erheben', 1000, 'd353b04b-a8d7-44b2-b70d-ec32c6b4e051', NULL),
	(0, '2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Biomaterial herausgeben', 1000, 'a1f6182a-7594-485e-9bae-3826668d7aa7', NULL),
	(0, '2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Biomaterial lagern', 1000, '4e833679-89ba-4aa3-9c2c-e9de6695423b', NULL),
	(0, '2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Identifizierende Daten erheben', 1000, '0496374d-108b-4cde-970f-7089b5481947', NULL),
	(0, '2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Identifizierende Daten speichern', 1000, 'c9401dbc-25f5-471c-b793-8291f70ab634', NULL),
	(0, '2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Medizinische Daten erheben', 1000, '0feb3192-d532-494f-8d7d-74ca657af1c3', NULL),
	(0, '2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Medizinische Daten herausgeben', 1000, '1e180627-95dd-4470-81a5-b0fc8ab6a4fa', NULL),
	(0, '2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Medizinische Daten speichern', 1000, '34e44676-5405-456a-9cbd-134d7db0a42a', NULL),
	(0, '2022-02-01 09:16:49.093', 1, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Rekontaktierung Folgestudie', 1000, 'e8ab6bbf-d044-4d6a-a0f2-4e86382ab143', NULL),
	(1, '2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Biomaterial erheben', 1000, '40894a34-b276-4078-83e1-ae6df26bf12f', NULL),
	(1, '2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Biomaterial herausgeben', 1000, '06033f2f-0597-4b70-b195-1ed9f7e6babf', NULL),
	(1, '2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Biomaterial lagern', 1000, '4f02e085-7383-4d34-9919-76eb5939c0e9', NULL),
	(0, '2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Identifizierende Daten erheben', 1000, '7fe1e4c7-f6cc-4050-bb7a-cc569fc25c9b', NULL),
	(0, '2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Identifizierende Daten speichern', 1000, 'd62eaa09-6a5d-407f-9c57-92f9dd9eef2b', NULL),
	(0, '2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Medizinische Daten erheben', 1000, 'cba07604-31a1-4120-92ea-0badb8747c41', NULL),
	(0, '2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Medizinische Daten herausgeben', 1000, 'c3669b84-ea18-4245-ac71-11cbed897914', NULL),
	(0, '2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Medizinische Daten speichern', 1000, '22cb0e2d-8d40-40cc-9501-3a1b1a53b9f6', NULL),
	(1, '2022-02-01 09:17:38.235', 2, 'Demo Deutschland', 'Einwilligung Demostudie', 1000, 'Demo Deutschland', 'Rekontaktierung Folgestudie', 1000, '98875d32-7126-4674-9c41-5209304a5c6c', NULL),
	(5, '2022-02-01 09:19:30.733', 1, 'Demo Deutschland', 'Widerruf Datenerhebung', 1000, 'Demo Deutschland', 'Biomaterial erheben', 1000, '846ecf15-e23c-472e-be3c-2729e0a59b5c', NULL),
	(5, '2022-02-01 09:19:30.733', 1, 'Demo Deutschland', 'Widerruf Datenerhebung', 1000, 'Demo Deutschland', 'Identifizierende Daten erheben', 1000, '3e1ac5e6-3122-4f6a-ab9c-66ddf4b5fad8', NULL),
	(5, '2022-02-01 09:19:30.733', 1, 'Demo Deutschland', 'Widerruf Datenerhebung', 1000, 'Demo Deutschland', 'Medizinische Daten erheben', 1000, '16cc987b-d128-4c7f-9ab9-74f404b20545', NULL),
	(0, '2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Collect Biomaterial', 1000, 'b526dceb-cbc3-4fa6-a701-b16ce6a77932', NULL),
	(0, '2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Collect Identifying Data', 1000, 'dba8abd5-e71d-48fd-ad3a-9b0174ffd111', NULL),
	(0, '2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Collect Medical Data', 1000, 'a748499d-e477-48b9-9571-b1e90a333d70', NULL),
	(0, '2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Recontact Follow Up Study', 1000, '1f297eee-368d-41ff-a778-94b6f8812840', NULL),
	(0, '2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Share Biomaterial', 1000, '9b073b45-93d6-4b6d-8af4-caa934f403b6', NULL),
	(0, '2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Share Medical Data', 1000, 'e2eaa48b-3f54-4496-80ef-94843f5cad8f', NULL),
	(0, '2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Store Biomaterial', 1000, '49670804-6873-4d2f-aa98-f914d50711dd', NULL),
	(0, '2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Store Identifying Data', 1000, '076c09d4-0022-426b-8678-80f0c8bb5423', NULL),
	(0, '2022-02-01 09:21:16.346', 3, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Store Medical Data', 1000, 'f08731ca-9f34-428c-a7c5-d61e377b1460', NULL),
	(1, '2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Collect Biomaterial', 1000, 'b828a1f6-8d30-4d1e-af70-d8580c39ed8c', NULL),
	(0, '2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Collect Identifying Data', 1000, 'f850a051-380c-44ca-9f60-a7abf865ffbf', NULL),
	(0, '2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Collect Medical Data', 1000, '70e2482f-7e6e-49f9-bc9e-080a5e35da8c', NULL),
	(1, '2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Recontact Follow Up Study', 1000, 'e9a5c0e8-e4df-4292-b2c3-fc763be201b1', NULL),
	(1, '2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Share Biomaterial', 1000, '7bfc59ec-3ee6-4b8c-a47c-86ae3f5c3ba9', NULL),
	(0, '2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Share Medical Data', 1000, 'affbf36a-889f-4563-98ec-ea93165986a0', NULL),
	(1, '2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Store Biomaterial', 1000, '45862ca9-a376-463f-b02b-7f53374d504f', NULL),
	(0, '2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Store Identifying Data', 1000, '3dfb8aff-f97d-4001-a79e-96a6296b3c88', NULL),
	(0, '2022-02-01 09:22:33.371', 4, 'Demo EU', 'Consent Demostudy', 1000, 'Demo EU', 'Store Medical Data', 1000, 'fb3ad053-40dd-42db-98ee-c41a197829c4', NULL),
	(5, '2022-02-01 09:23:23.758', 3, 'Demo EU', 'Withdrawal Data Collection', 1000, 'Demo EU', 'Collect Biomaterial', 1000, 'a7db263e-4951-4a92-8d5d-fe5815f6da4e', NULL),
	(5, '2022-02-01 09:23:23.758', 3, 'Demo EU', 'Withdrawal Data Collection', 1000, 'Demo EU', 'Collect Identifying Data', 1000, '82823652-5fe4-4af1-abc4-290468bfe5f5', NULL),
	(5, '2022-02-01 09:23:23.758', 3, 'Demo EU', 'Withdrawal Data Collection', 1000, 'Demo EU', 'Collect Medical Data', 1000, '2b16efa4-c500-468c-829d-1eb1df63de7a', NULL),
	(1, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Analysedaten_zusammenfuehren_Dritte', 1001, '8085efb3-34b2-4b5c-94c5-d683a5457f0b', NULL),
	(1, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Eigentum_uebertragen', 1000, 'c6d79171-b455-432f-8967-a3deef917f86', NULL),
	(1, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Zusatzmengen_entnehmen', 1000, 'dd3625b6-55a1-4b89-bfa6-33c43733104e', NULL),
	(1, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_erheben', 1001, 'b0c4970a-0387-42ae-a760-3f1d66e50af5', NULL),
	(1, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_lagern_verarbeiten', 1000, '2e234222-58eb-4b4c-8626-6f10bf758e2a', NULL),
	(1, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, '8fab38c2-1b9e-49a2-957a-84422c57470c', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_bereitstellen_EU_DSGVO_konform', 1001, 'f5e83385-ed2b-487e-b588-bdc6f6e2dbf9', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_erheben', 1000, '9184a816-30bb-4a7a-9fd3-1feb837196be', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_speichern_verarbeiten', 1000, '6ceb89cd-85af-425e-b5ef-2f8b3df07f47', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_zusammenfuehren_Dritte', 1000, 'f21b5131-39f7-46f6-9688-79477d76d891', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_speichern_verarbeiten', 1000, 'a94fefb7-489f-406b-8900-11cbe00909c5', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_uebertragen', 1000, '76c869c2-4f0e-4fe0-b79b-944123b9dea4', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_wissenschaftlich_nutzen', 1000, '73cea025-3990-456f-9346-f90533ea7127', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_speichern_verarbeiten', 1001, '040dffe9-6256-4b1b-865c-25d2e4c10a9f', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_uebertragen', 1000, '5781c037-008a-4368-b379-9b3224230e97', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_wissenschaftlich_nutzen', 1000, '432f4c21-60bb-4076-979f-4da566540896', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_KVNR_5J_pro_uebertragen', 1000, '5ce047be-c5d7-4774-ab34-09c9a42cd785', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_KVNR_5J_retro_uebertragen', 1000, '0c5adb4f-1f3a-4041-91ac-23e7feb6931f', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_erheben', 1001, '58efa868-7537-4cf7-a678-845b79969823', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_speichern_verarbeiten', 1000, '68323454-a2b7-4e94-8859-cffa4a931166', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, '07f12bcc-c405-4934-942e-584a692f5993', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_zusammenfuehren_Dritte', 1000, 'e64481a6-643f-454f-bac4-3c4e6bf2c300', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Ergebnisse_erheblicher_Bedeutung', 1000, '0e69b971-49aa-4e6f-81d8-61eb7f1c5c75', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Verknuepfung_Datenbanken', 1000, '6aae3119-0647-4156-8426-2385912e7684', NULL),
	(1, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Zusatzbefund', 1000, 'd718574d-8cfe-48f1-aa0f-7cb1219add8d', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_weitere_Erhebung', 1001, '6110402a-4a02-4d3d-80d3-c8823ba03f66', NULL),
	(0, '2022-02-01 09:27:24.146', 5, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_weitere_Studien', 1001, 'a67d51e8-f736-4199-9046-5bea359dcae5', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Analysedaten_zusammenfuehren_Dritte', 1001, '71673ecd-aa77-4bbe-aaad-5bdf17b65f8b', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Eigentum_uebertragen', 1000, '3070bd05-f98f-4962-9c54-fb542e690023', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Zusatzmengen_entnehmen', 1000, '42e4193f-a2d8-4942-b387-5e871b6353c2', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_erheben', 1001, 'aede041a-c54a-46fc-9cc7-8640571d81e8', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_lagern_verarbeiten', 1000, '92a72a05-6f17-480a-98d3-1044e53f85be', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, '40c3b33f-a5c2-48aa-a5ee-fa9bedfbe0cf', NULL),
	(0, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_bereitstellen_EU_DSGVO_konform', 1001, '4eba54c9-103a-48f8-87e0-b5523d2b0c05', NULL),
	(0, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_erheben', 1000, '2ea13320-f538-405a-9d45-569900f17e3b', NULL),
	(0, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_speichern_verarbeiten', 1000, '5b25bcdc-591e-45a1-b597-023deaa845f1', NULL),
	(0, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_zusammenfuehren_Dritte', 1000, '4adbb198-f76f-4f5f-9649-e2652c01376a', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_speichern_verarbeiten', 1000, '64df979d-83d7-4441-ba2b-4efdd9655f1d', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_uebertragen', 1000, 'a2d4286d-ab31-4be1-965c-73122cf5d21c', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_wissenschaftlich_nutzen', 1000, 'bd0dc56a-53aa-4ed9-b55d-9f65aea22810', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_speichern_verarbeiten', 1001, '8fe04f58-1a82-4da1-b430-00101958a488', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_uebertragen', 1000, 'ee16b560-ddb7-46e5-9fc5-abf88a00672d', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_wissenschaftlich_nutzen', 1000, '40e2fefb-f02d-450e-91f6-b8d96f1790fd', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_KVNR_5J_pro_uebertragen', 1000, '0335add2-9bc4-434a-9c43-85cbfea46b86', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_KVNR_5J_retro_uebertragen', 1000, 'c52ef078-4c7f-4d27-9e48-270301dd5738', NULL),
	(0, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_erheben', 1001, 'daf82d2c-79de-4b9a-801e-3fe95e32435c', NULL),
	(0, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_speichern_verarbeiten', 1000, '01ca5d45-d244-41a9-948d-2e2597737b1a', NULL),
	(0, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, '73b9f50c-2b72-4457-8fbd-7221433d754b', NULL),
	(0, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_zusammenfuehren_Dritte', 1000, '978aaa2b-9d7d-42ff-bf5f-1009fd1e2037', NULL),
	(0, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Ergebnisse_erheblicher_Bedeutung', 1000, 'cfa78ba1-1794-4ad5-bb0e-244992e7ab00', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Verknuepfung_Datenbanken', 1000, 'd79ce9ae-c8e4-4154-ba8d-8d44ca51206c', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Zusatzbefund', 1000, '4379b6be-5d7c-4eb2-a1bb-b85c4b705d57', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_weitere_Erhebung', 1001, 'a6f5b3a7-a62d-4e89-829d-63b5524c4225', NULL),
	(1, '2022-02-01 09:30:19.377', 6, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_weitere_Studien', 1001, '2eb6e531-355a-4337-b356-e6dcc91204a4', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Analysedaten_zusammenfuehren_Dritte', 1001, '69fe41bf-69b5-463c-9087-d539dcd1583e', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Eigentum_uebertragen', 1000, '9ce224ef-760e-46ca-8d8b-415274c342db', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Zusatzmengen_entnehmen', 1000, '302cb418-b4a4-462c-927b-a4fea2e56389', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_erheben', 1001, '962319d9-56a1-4539-b8c2-c47441ca1b54', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_lagern_verarbeiten', 1000, '1633bc24-84b1-44a6-8770-0602e7c58588', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, '68ad6b2b-161d-4513-8d1a-d4e141e58e63', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_bereitstellen_EU_DSGVO_konform', 1001, 'fb5114ed-f69c-495d-8096-2db2e7ba7ab4', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_erheben', 1000, '49fa8bc5-51b0-4794-b485-723491c0caad', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_speichern_verarbeiten', 1000, '785a6b32-147b-4f41-8572-7b73c22ab8fe', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_zusammenfuehren_Dritte', 1000, 'ed7f3eec-e286-4a67-89f3-0b4dc3ca26d0', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_speichern_verarbeiten', 1000, '97bfdca2-5652-4f89-a20b-fe28dd9bee1a', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_uebertragen', 1000, 'a31f342c-c394-470d-a881-9a94aa84d50a', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_wissenschaftlich_nutzen', 1000, '1a600b85-7524-44f4-8d6f-fda4933389cf', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_speichern_verarbeiten', 1001, '796e5a66-656e-4e4b-9b02-4480c32190f4', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_uebertragen', 1000, 'd2b6a575-15d5-4d2b-b3d3-5b8c4c718600', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_wissenschaftlich_nutzen', 1000, 'e0ba19ef-e3c5-4fdb-84a2-553cf6167dc4', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_KVNR_5J_pro_uebertragen', 1000, 'fe534ed8-a2e5-4c43-9feb-7281427123f2', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_KVNR_5J_retro_uebertragen', 1000, '4ab0e109-f7f2-4eac-b121-1e19c7ec887f', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_erheben', 1001, '1299548a-a3bd-4973-8fd0-0262de0ce97e', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_speichern_verarbeiten', 1000, '72a17905-bc35-4689-aad2-5fe2a3787bab', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, 'a968aeaf-da78-470a-8f24-b8ad35d7edab', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_zusammenfuehren_Dritte', 1000, 'b6be8418-7c6a-4b86-9bb0-740db7c25ec7', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Ergebnisse_erheblicher_Bedeutung', 1000, 'bc31a38d-d1e4-4db6-81d9-2012d24d7bfa', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Verknuepfung_Datenbanken', 1000, '7ee48a8c-b2ea-43f6-b481-29268dcc33c5', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Zusatzbefund', 1000, 'ad6050b5-06b5-4c56-ac58-460eb04aad0d', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_weitere_Erhebung', 1001, '88f4d6d0-74e2-4f3d-ba20-45ee332732cd', NULL),
	(0, '2022-02-01 09:31:40.632', 7, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_weitere_Studien', 1001, '47a508cc-f9fb-472b-a9ca-b72593cd6a81', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_Analysedaten_zusammenfuehren_Dritte', 1001, 'e498870e-b025-48ce-ad41-e216bf19e330', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_Eigentum_uebertragen', 1000, '2a03a0a4-ec3a-4e54-abc9-94392dbbac33', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_Zusatzmengen_entnehmen', 1000, '2051ddc1-3d4f-4a77-bc45-1a8c56c53362', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_erheben', 1001, 'd1f7e398-313b-4187-995b-4de0461f02fe', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_lagern_verarbeiten', 1000, '982491f0-eb0b-4e97-a2da-0148014800f1', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, '1259dbac-eca1-45e7-86c7-0c8e08b697b4', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'IDAT_bereitstellen_EU_DSGVO_konform', 1001, '9a6426c1-8e33-4e54-b213-3677ef3bca4f', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'IDAT_erheben', 1000, '0fff7b26-66c7-4828-8990-43336736f09d', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'IDAT_speichern_verarbeiten', 1000, 'b6133d4c-3422-4b91-917a-d7e8f8fa17cc', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'IDAT_zusammenfuehren_Dritte', 1000, '68bc0b1e-3251-4dab-88ce-b3aa93f0b49b', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_pro_speichern_verarbeiten', 1000, 'b6e658f4-c9e5-4924-a538-bb8cc817e677', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_pro_uebertragen', 1000, '972567b6-9144-488a-87a4-4f15e0ef5727', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_pro_wissenschaftlich_nutzen', 1000, 'b87827b4-19b2-444d-b45d-c8453781693f', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_retro_speichern_verarbeiten', 1001, 'ccabcb11-6b75-4d99-b897-2296df4cffec', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_retro_uebertragen', 1000, 'd611b826-0f85-4181-a4d6-bee4ddb95855', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_retro_wissenschaftlich_nutzen', 1000, '4c7be47f-4cef-4717-b67e-0e17fa4bf9fb', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_KVNR_5J_pro_uebertragen', 1000, '44661b08-e1db-4ec9-8b0f-784c2f81435b', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_KVNR_5J_retro_uebertragen', 1000, '839174e5-296a-48d2-bad6-cff9bb1705ed', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'MDAT_erheben', 1001, '07f0da21-571d-4b8a-a356-8d21b4af9d75', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'MDAT_speichern_verarbeiten', 1000, 'c702ae46-3b75-42ad-a14c-7c80e1b2e0c7', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, 'c4ce0ad9-9580-4ada-8ee6-a09ba5df8084', NULL),
	(4, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'MDAT_zusammenfuehren_Dritte', 1000, '4a87435f-289d-48ba-95af-3c5a5fab7993', NULL),
	(5, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Rekontaktierung_Ergebnisse_erheblicher_Bedeutung', 1000, 'a64e737e-691c-45ed-831e-8ab437004c5d', NULL),
	(5, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Rekontaktierung_Verknuepfung_Datenbanken', 1000, '0d14f709-c022-4722-99ac-8db1069dcce5', NULL),
	(5, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Rekontaktierung_Zusatzbefund', 1000, '5be61f2f-6c26-4666-a721-fbc069b46a5b', NULL),
	(5, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Rekontaktierung_weitere_Erhebung', 1001, '435277b6-c06b-4922-9932-2bd1b99287dd', NULL),
	(5, '2022-02-01 09:32:36.448', 7, 'MII', 'Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Rekontaktierung_weitere_Studien', 1001, 'a2e3fbc9-6376-4a07-842f-16f26d525452', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_Analysedaten_zusammenfuehren_Dritte', 1001, '6fe310fa-b173-46ab-974d-e9b8c1ce7cd6', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_Eigentum_uebertragen', 1000, 'ecaa5dcc-b8cb-4f0e-88f8-d6d54e0b7855', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_Zusatzmengen_entnehmen', 1000, '975c52aa-7b1f-4da1-89b4-60e196d0f82d', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_erheben', 1001, '723afbd1-bea8-4c8b-9738-7077363778df', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_lagern_verarbeiten', 1000, 'e3fbc5cc-e0a0-4858-a9db-b041abf6453e', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, 'e0b9e3da-60aa-4efb-b243-51cfc05f9904', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'IDAT_bereitstellen_EU_DSGVO_konform', 1001, '44887c8c-53af-478d-bf16-bc010e89be7e', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'IDAT_erheben', 1000, 'f4f058fc-e63d-4182-8cc8-4125e3e2fb5e', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'IDAT_speichern_verarbeiten', 1000, '9dc42eca-4b7b-43e5-9309-f87cd9531528', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'IDAT_zusammenfuehren_Dritte', 1000, '53ff076b-76b1-42a3-b7ac-3a020d36620a', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_pro_speichern_verarbeiten', 1000, '2fd364c5-400a-4e30-8114-9cd59f38be39', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_pro_uebertragen', 1000, 'f53b4fe8-8964-4ded-9af7-5ebb125dab35', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_pro_wissenschaftlich_nutzen', 1000, 'adeaff39-c860-4db6-89c8-0b0fe1e1f5e7', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_retro_speichern_verarbeiten', 1001, 'df55a12b-3a39-408a-898a-d74b56afd867', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_retro_uebertragen', 1000, '912d3828-2e06-4a2b-bb42-5f55f6cd599e', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_5J_retro_wissenschaftlich_nutzen', 1000, 'a4d9128e-1ad1-4123-bebe-4e8707d19e1b', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_KVNR_5J_pro_uebertragen', 1000, '213eb6eb-a8d0-4df9-b053-08e1ef894a35', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'KKDAT_KVNR_5J_retro_uebertragen', 1000, '2677728e-2c0b-46a9-a899-d63a4467c619', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'MDAT_erheben', 1001, '96f56008-8362-4a3e-99db-6019c31012be', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'MDAT_speichern_verarbeiten', 1000, '3914ae45-58f1-4029-a030-6d4bdee10e13', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, '2e1e9c3a-6415-4ce9-ac92-326d4f6a2a4c', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'MDAT_zusammenfuehren_Dritte', 1000, '421f559b-3ccc-41a5-b8c7-b718e1d77825', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Rekontaktierung_Ergebnisse_erheblicher_Bedeutung', 1000, '00b82137-ff3c-487b-b86f-61804c10345f', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Rekontaktierung_Verknuepfung_Datenbanken', 1000, '2bc2b936-a113-45d8-8dbc-0b582fd5f234', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Rekontaktierung_Zusatzbefund', 1000, 'd76cf5e1-7ded-46c3-a63a-1aced36f1b90', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Rekontaktierung_weitere_Erhebung', 1001, '23fe0847-3648-40bd-81d4-733e875c545c', NULL),
	(5, '2022-02-01 09:33:28.627', 7, 'MII', 'Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)', 2000000, 'MII', 'Rekontaktierung_weitere_Studien', 1001, 'aaaec343-4ba0-4f09-b99b-7dc42fab7aef', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Analysedaten_zusammenfuehren_Dritte', 1001, 'e9bbc1a2-1253-4761-9368-9495fb40f726', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Eigentum_uebertragen', 1000, 'b3d59acd-b7d4-4950-be0f-b8876cf66aef', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_Zusatzmengen_entnehmen', 1000, '88682b45-bc37-4fb3-ab95-4510d47c97ef', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_erheben', 1001, 'f3f10232-145e-4226-a428-f8b447a42114', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_lagern_verarbeiten', 1000, 'faec454d-8684-4704-8247-63c8a209b85f', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, '6009a9ae-aa1b-4479-a413-e503c5e6e9cb', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_bereitstellen_EU_DSGVO_konform', 1001, 'd5ad5de3-bee9-4d28-925b-5b28a771cd74', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_erheben', 1000, '600a0398-ab1c-43eb-b789-0c2ded5d0333', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_speichern_verarbeiten', 1000, '9f7d35e5-6929-43fc-80c9-72f539121987', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'IDAT_zusammenfuehren_Dritte', 1000, '2e4f7028-58c9-4550-a1eb-95ce90c56852', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_speichern_verarbeiten', 1000, 'bb62e9d9-e0e0-4b13-abe8-1defbd6fae9b', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_uebertragen', 1000, '365539d9-5c74-492e-b6ea-2ace7fbeba99', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_pro_wissenschaftlich_nutzen', 1000, '60152620-c816-4a49-a510-8876ffef8d2d', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_speichern_verarbeiten', 1001, '172b3e34-e2a8-4d32-b591-eb8e2ba2ec24', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_uebertragen', 1000, '3dee8813-327d-4eff-925d-549ab7cfe0f1', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_5J_retro_wissenschaftlich_nutzen', 1000, '0cd490e2-5141-42cb-badd-1a4cb9e2c1d1', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_KVNR_5J_pro_uebertragen', 1000, '6aa9e615-ea87-4296-938d-ec818de700aa', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'KKDAT_KVNR_5J_retro_uebertragen', 1000, 'cc9925b5-5ffc-460b-98f1-a677223c09d5', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_erheben', 1001, '28d3bd73-5cc5-4491-a1c2-cce39c0cb67f', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_speichern_verarbeiten', 1000, '66f37ed6-c00a-4365-a243-69162c4d3862', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform', 1000, 'b746e776-b5d6-4fba-a60c-eba3c4fcb686', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'MDAT_zusammenfuehren_Dritte', 1000, 'eff8ac8b-65fd-4f98-9ae1-dd91a795cbfc', NULL),
	(0, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Ergebnisse_erheblicher_Bedeutung', 1000, '5d968821-37f5-4725-bead-45f9595a85da', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Verknuepfung_Datenbanken', 1000, '757b6ef1-29d8-4e6c-8723-3f9ec12de46b', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_Zusatzbefund', 1000, '0f802373-b8f0-4330-9ad3-7c47ff5e36b4', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_weitere_Erhebung', 1001, '13849c2b-09e6-48b5-8fdb-57972b71590d', NULL),
	(1, '2022-02-01 09:55:08.225', 8, 'MII', 'Patienteneinwilligung MII', 1006003, 'MII', 'Rekontaktierung_weitere_Studien', 1001, 'b3e506c0-2aa7-4081-b81e-55cd7661c5b0', NULL);

-- Exportiere Daten aus Tabelle gics.signer_id: ~8 rows (ungefähr)
INSERT IGNORE INTO `signer_id` (`VALUE`, `SIT_DOMAIN_NAME`, `SIT_NAME`, `CREATE_TIMESTAMP`, `FHIR_ID`) VALUES
	('S-00001', 'Demo Deutschland', 'Pseudonym', '2022-02-01 09:16:49.153', '2c16e64e-55c0-4b7b-884b-050ceb7cff4f'),
	('S-00002', 'Demo Deutschland', 'Pseudonym', '2022-02-01 09:17:38.245', '659abafb-e9ab-4406-b686-e8a8d6d49730'),
	('S-00101', 'Demo EU', 'Study-ID', '2022-02-01 09:21:16.356', 'acfe7c7e-584a-4c47-8168-f1d791772501'),
	('S-00102', 'Demo EU', 'Study-ID', '2022-02-01 09:22:33.390', 'b69b709b-7509-4752-aebd-d6f65f23c103'),
	('dic_1H51T', 'MII', 'Pseudonym', '2022-02-01 09:27:24.164', 'b633eae0-980d-490f-ae1b-dd93756c767a'),
	('dic_61C5X', 'MII', 'Pseudonym', '2022-02-01 09:30:19.385', 'aa16913e-6c40-475d-94b1-ed1b9ada09ac'),
	('dic_810MT', 'MII', 'Pseudonym', '2022-02-01 09:55:08.237', '34bc2e4b-e7f5-4131-af47-ae042c91871d'),
	('dic_R3M0V3', 'MII', 'Pseudonym', '2022-02-01 09:31:40.645', '531cef77-2a30-4283-944d-affaf9ae234e');

-- Exportiere Daten aus Tabelle gics.signer_id_type: ~3 rows (ungefähr)
INSERT IGNORE INTO `signer_id_type` (`NAME`, `DOMAIN_NAME`, `CREATE_TIMESTAMP`, `UPDATE_TIMESTAMP`, `LABEL`, `COMMENT`, `ORDER_NUMBER`, `FHIR_ID`) VALUES
	('Pseudonym', 'Demo Deutschland', '2022-02-01 09:15:26.306', '2022-02-01 09:15:26.306', NULL, NULL, 1, 'f51cc87e-5674-4937-a374-adbde63fde29'),
	('Pseudonym', 'MII', '2022-02-01 09:13:27.789', '2022-02-01 09:13:27.789', NULL, NULL, 1, '2e040fc3-0e91-4148-a8bd-0ff2d9b25982'),
	('Study-ID', 'Demo EU', '2022-02-01 09:15:40.644', '2022-02-01 09:15:40.644', NULL, NULL, 1, '6bd15873-b3d6-493e-bad2-cefdeb5adcaa');

-- Exportiere Daten aus Tabelle gics.stat_entry: ~0 rows (ungefähr)
INSERT IGNORE INTO `stat_entry` (`STAT_ENTRY_ID`, `ENTRYDATE`) VALUES
	(1, '2022-02-28 23:00:00.000'),
	(2, '2022-03-01 23:00:00.000'),
	(3, '2022-03-04 18:52:52.645');

-- Exportiere Daten aus Tabelle gics.stat_value: ~0 rows (ungefähr)
INSERT IGNORE INTO `stat_value` (`stat_value_id`, `stat_value`, `stat_attr`) VALUES
	(1, 0, 'qc_valid.per_domain.Demo Deutschland'),
	(1, 3, 'qc_valid.per_domain.Demo EU'),
	(1, 6, 'qc_valid.per_domain.MII'),
	(1, 4, 'informed_consents.per_domain.MII'),
	(1, 0, 'qc.per_domain.Demo Deutschland.per_qctype.not_checked'),
	(1, 1, 'documents.per_domain.Demo EU.per_template.Withdrawal Data Collection1.0'),
	(1, 0, 'qc_invalid.per_domain.Demo Deutschland'),
	(1, 0, 'qc.per_domain.Demo Deutschland.per_qctype.###_auto_generated_###'),
	(1, 35, 'modules_without_versions'),
	(1, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym'),
	(1, 0, 'refusals.per_domain.MII'),
	(1, 3, 'templates.per_domain.MII'),
	(1, 2, 'templates.per_domain.Demo Deutschland'),
	(1, 0, 'refusals'),
	(1, 0, 'qc.per_domain.Demo EU.per_qctype.checked_major_faults'),
	(1, 1, 'withdrawals.per_domain.Demo EU'),
	(1, 0, 'documents_expired_full.per_domain.MII'),
	(1, 0, 'qc.per_domain.Demo EU.per_qctype.invalidated'),
	(1, 8, 'informed_consents'),
	(1, 0, 'qc.per_domain.MII.per_qctype.invalidated'),
	(1, 0, 'qc.per_domain.Demo EU.per_qctype.checked_no_faults'),
	(1, 9, 'policies.per_domain.Demo EU'),
	(1, 0, 'qc.per_domain.Demo EU.per_qctype.checked_minor_faults'),
	(1, 0, 'documents_with_scans.per_domain.Demo EU'),
	(1, 0, 'refusals.per_domain.Demo EU'),
	(1, 1, 'documents.per_domain.MII.per_template.Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)2.0.a'),
	(1, 0, 'qc.per_domain.Demo Deutschland.per_qctype.checked_major_faults'),
	(1, 4, 'withdrawals'),
	(1, 2, 'informed_consents.per_domain.Demo EU'),
	(1, 0, 'qc.per_domain.MII.per_qctype.checked_major_faults'),
	(1, 0, 'qc.per_domain.MII.per_qctype.###_auto_generated_###'),
	(1, 3, 'qc.per_domain.MII.per_qctype.not_checked'),
	(1, 35, 'modules_with_versions'),
	(1, 3, 'qc.per_domain.Demo EU.per_qctype.not_checked'),
	(1, 4, 'documents.per_domain.MII.per_template.Patienteneinwilligung MII1.6.d'),
	(1, 3, 'documents_with_digital_patientsignature.per_domain.Demo EU'),
	(1, 2, 'withdrawals.per_domain.MII'),
	(1, 27, 'policies.per_domain.MII'),
	(1, 0, 'documents_with_digital_patientsignature.per_domain.Demo Deutschland'),
	(1, 0, 'refusals.per_domain.Demo Deutschland'),
	(1, 0, 'informed_consents.per_domain.Demo Deutschland'),
	(1, 9, 'policies.per_domain.Demo Deutschland'),
	(1, 0, 'qc.per_domain.Demo Deutschland.per_qctype.checked_no_faults'),
	(1, 0, 'qc.per_domain.Demo EU.per_qctype.###_auto_generated_###'),
	(1, 0, 'qc_invalid.per_domain.MII'),
	(1, 0, 'documents_expired_full.per_domain.Demo Deutschland'),
	(1, 846, 'calculation_time'),
	(1, 7, 'templates'),
	(1, 0, 'qc.per_domain.Demo Deutschland.per_qctype.invalidated'),
	(1, 11, 'documents_with_digital_patientsignature'),
	(1, 5, 'documents_with_digital_patientsignature.per_domain.MII'),
	(1, 4, 'modules_with_versions.per_domain.Demo EU'),
	(1, 27, 'modules_with_versions.per_domain.MII'),
	(1, 2, 'templates.per_domain.Demo EU'),
	(1, 4, 'modules_with_versions.per_domain.Demo Deutschland'),
	(1, 3, 'documents_with_scans'),
	(1, 2, 'documents.per_domain.Demo EU.per_template.Consent Demostudy1.0'),
	(1, 0, 'withdrawals.per_domain.Demo Deutschland'),
	(1, 4, 'signer_ids.per_domain.MII.per_idtype.Pseudonym'),
	(1, 0, 'documents_expired_full.per_domain.Demo EU'),
	(1, 1, 'documents.per_domain.MII.per_template.Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)2.0.a'),
	(1, 2, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID'),
	(1, 0, 'documents.per_domain.Demo Deutschland.per_template.Widerruf Datenerhebung1.0'),
	(1, 0, 'documents_with_scans.per_domain.Demo Deutschland'),
	(1, 0, 'documents.per_domain.Demo Deutschland.per_template.Einwilligung Demostudie1.0'),
	(1, 1, 'qc.per_domain.MII.per_qctype.checked_minor_faults'),
	(1, 0, 'qc.per_domain.Demo Deutschland.per_qctype.checked_minor_faults'),
	(1, 3, 'domains'),
	(1, 2, 'qc.per_domain.MII.per_qctype.checked_no_faults'),
	(1, 45, 'policies'),
	(1, 0, 'qc_invalid.per_domain.Demo EU'),
	(1, 3, 'documents_with_scans.per_domain.MII'),
	(2, 2, 'qc_valid.per_domain.Demo Deutschland'),
	(2, 3, 'qc_valid.per_domain.Demo EU'),
	(2, 6, 'qc_valid.per_domain.MII'),
	(2, 4, 'informed_consents.per_domain.MII'),
	(2, 2, 'qc.per_domain.Demo Deutschland.per_qctype.not_checked'),
	(2, 1, 'documents.per_domain.Demo EU.per_template.Withdrawal Data Collection1.0'),
	(2, 0, 'qc_invalid.per_domain.Demo Deutschland'),
	(2, 0, 'qc.per_domain.Demo Deutschland.per_qctype.###_auto_generated_###'),
	(2, 35, 'modules_without_versions'),
	(2, 2, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym'),
	(2, 0, 'refusals.per_domain.MII'),
	(2, 3, 'templates.per_domain.MII'),
	(2, 2, 'templates.per_domain.Demo Deutschland'),
	(2, 0, 'refusals'),
	(2, 0, 'qc.per_domain.Demo EU.per_qctype.checked_major_faults'),
	(2, 1, 'withdrawals.per_domain.Demo EU'),
	(2, 0, 'documents_expired_full.per_domain.MII'),
	(2, 0, 'qc.per_domain.Demo EU.per_qctype.invalidated'),
	(2, 8, 'informed_consents'),
	(2, 0, 'qc.per_domain.MII.per_qctype.invalidated'),
	(2, 0, 'qc.per_domain.Demo EU.per_qctype.checked_no_faults'),
	(2, 9, 'policies.per_domain.Demo EU'),
	(2, 0, 'qc.per_domain.Demo EU.per_qctype.checked_minor_faults'),
	(2, 0, 'documents_with_scans.per_domain.Demo EU'),
	(2, 0, 'refusals.per_domain.Demo EU'),
	(2, 1, 'documents.per_domain.MII.per_template.Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)2.0.a'),
	(2, 0, 'qc.per_domain.Demo Deutschland.per_qctype.checked_major_faults'),
	(2, 4, 'withdrawals'),
	(2, 2, 'informed_consents.per_domain.Demo EU'),
	(2, 0, 'qc.per_domain.MII.per_qctype.checked_major_faults'),
	(2, 0, 'qc.per_domain.MII.per_qctype.###_auto_generated_###'),
	(2, 3, 'qc.per_domain.MII.per_qctype.not_checked'),
	(2, 35, 'modules_with_versions'),
	(2, 3, 'qc.per_domain.Demo EU.per_qctype.not_checked'),
	(2, 4, 'documents.per_domain.MII.per_template.Patienteneinwilligung MII1.6.d'),
	(2, 3, 'documents_with_digital_patientsignature.per_domain.Demo EU'),
	(2, 2, 'withdrawals.per_domain.MII'),
	(2, 27, 'policies.per_domain.MII'),
	(2, 2, 'documents_with_digital_patientsignature.per_domain.Demo Deutschland'),
	(2, 0, 'refusals.per_domain.Demo Deutschland'),
	(2, 2, 'informed_consents.per_domain.Demo Deutschland'),
	(2, 9, 'policies.per_domain.Demo Deutschland'),
	(2, 0, 'qc.per_domain.Demo Deutschland.per_qctype.checked_no_faults'),
	(2, 0, 'qc.per_domain.Demo EU.per_qctype.###_auto_generated_###'),
	(2, 0, 'qc_invalid.per_domain.MII'),
	(2, 0, 'documents_expired_full.per_domain.Demo Deutschland'),
	(2, 846, 'calculation_time'),
	(2, 7, 'templates'),
	(2, 0, 'qc.per_domain.Demo Deutschland.per_qctype.invalidated'),
	(2, 11, 'documents_with_digital_patientsignature'),
	(2, 5, 'documents_with_digital_patientsignature.per_domain.MII'),
	(2, 4, 'modules_with_versions.per_domain.Demo EU'),
	(2, 27, 'modules_with_versions.per_domain.MII'),
	(2, 2, 'templates.per_domain.Demo EU'),
	(2, 4, 'modules_with_versions.per_domain.Demo Deutschland'),
	(2, 3, 'documents_with_scans'),
	(2, 2, 'documents.per_domain.Demo EU.per_template.Consent Demostudy1.0'),
	(2, 0, 'withdrawals.per_domain.Demo Deutschland'),
	(2, 4, 'signer_ids.per_domain.MII.per_idtype.Pseudonym'),
	(2, 0, 'documents_expired_full.per_domain.Demo EU'),
	(2, 1, 'documents.per_domain.MII.per_template.Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)2.0.a'),
	(2, 2, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID'),
	(2, 0, 'documents.per_domain.Demo Deutschland.per_template.Widerruf Datenerhebung1.0'),
	(2, 0, 'documents_with_scans.per_domain.Demo Deutschland'),
	(2, 2, 'documents.per_domain.Demo Deutschland.per_template.Einwilligung Demostudie1.0'),
	(2, 1, 'qc.per_domain.MII.per_qctype.checked_minor_faults'),
	(2, 0, 'qc.per_domain.Demo Deutschland.per_qctype.checked_minor_faults'),
	(2, 3, 'domains'),
	(2, 2, 'qc.per_domain.MII.per_qctype.checked_no_faults'),
	(2, 45, 'policies'),
	(2, 0, 'qc_invalid.per_domain.Demo EU'),
	(2, 3, 'documents_with_scans.per_domain.MII'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_retro_uebertragen1.0.per_status.ACCEPTED'),
	(3, 3, 'qc_valid.per_domain.Demo Deutschland'),
	(3, 3, 'qc_valid.per_domain.Demo EU'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_zusammenfuehren_Dritte1.0.per_status.ACCEPTED'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_retro_wissenschaftlich_nutzen1.0.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_bereitstellen_EU_DSGVO_konform1.1.per_status.UNKNOWN'),
	(3, 6, 'qc_valid.per_domain.MII'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_Verknuepfung_Datenbanken1.0.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_erheben1.1.per_status.DECLINED'),
	(3, 4, 'informed_consents.per_domain.MII'),
	(3, 0, 'qc.per_domain.Demo Deutschland.per_qctype.not_checked'),
	(3, 1, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Identifizierende Daten erheben1.0.per_status.ACCEPTED'),
	(3, 4, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_speichern_verarbeiten1.0.per_status.ACCEPTED'),
	(3, 2, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Medizinische Daten erheben1.0.per_status.ACCEPTED'),
	(3, 2, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Collect Identifying Data1.0.per_status.ACCEPTED'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_Zusatzmengen_entnehmen1.0.per_status.ACCEPTED'),
	(3, 1, 'documents.per_domain.Demo EU.per_template.Withdrawal Data Collection1.0'),
	(3, 0, 'qc_invalid.per_domain.Demo Deutschland'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_pro_wissenschaftlich_nutzen1.0.per_status.ACCEPTED'),
	(3, 0, 'qc.per_domain.Demo Deutschland.per_qctype.###_auto_generated_###'),
	(3, 35, 'modules_without_versions'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Medizinische Daten herausgeben1.0.per_status.UNKNOWN'),
	(3, 2, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym'),
	(3, 0, 'refusals.per_domain.MII'),
	(3, 3, 'templates.per_domain.MII'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_pro_uebertragen1.0.per_status.DECLINED'),
	(3, 2, 'templates.per_domain.Demo Deutschland'),
	(3, 1, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Biomaterial erheben1.0.per_status.DECLINED'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_bereitstellen_EU_DSGVO_konform1.1.per_status.DECLINED'),
	(3, 1, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Biomaterial herausgeben1.0.per_status.DECLINED'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_pro_speichern_verarbeiten1.0.per_status.ACCEPTED'),
	(3, 1, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Recontact Follow Up Study1.0.per_status.DECLINED'),
	(3, 0, 'refusals'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform1.0.per_status.UNKNOWN'),
	(3, 0, 'qc.per_domain.Demo EU.per_qctype.checked_major_faults'),
	(3, 1, 'withdrawals.per_domain.Demo EU'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Collect Biomaterial1.0.per_status.UNKNOWN'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform1.0.per_status.DECLINED'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_Eigentum_uebertragen1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Store Medical Data1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_erheben1.1.per_status.UNKNOWN'),
	(3, 0, 'documents_expired_full.per_domain.MII'),
	(3, 0, 'qc.per_domain.Demo EU.per_qctype.invalidated'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_speichern_verarbeiten1.0.per_status.UNKNOWN'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_Analysedaten_zusammenfuehren_Dritte1.1.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_lagern_verarbeiten1.0.per_status.UNKNOWN'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_weitere_Studien1.1.per_status.DECLINED'),
	(3, 8, 'informed_consents'),
	(3, 0, 'qc.per_domain.MII.per_qctype.invalidated'),
	(3, 2, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Store Identifying Data1.0.per_status.ACCEPTED'),
	(3, 0, 'qc.per_domain.Demo EU.per_qctype.checked_no_faults'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_retro_speichern_verarbeiten1.1.per_status.ACCEPTED'),
	(3, 1, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Store Biomaterial1.0.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_erheben1.0.per_status.UNKNOWN'),
	(3, 9, 'policies.per_domain.Demo EU'),
	(3, 1, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Biomaterial lagern1.0.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_Eigentum_uebertragen1.0.per_status.UNKNOWN'),
	(3, 0, 'qc.per_domain.Demo EU.per_qctype.checked_minor_faults'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Store Identifying Data1.0.per_status.UNKNOWN'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_bereitstellen_EU_DSGVO_konform1.1.per_status.ACCEPTED'),
	(3, 1, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Biomaterial herausgeben1.0.per_status.ACCEPTED'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_lagern_verarbeiten1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Share Biomaterial1.0.per_status.UNKNOWN'),
	(3, 0, 'documents_with_scans.per_domain.Demo EU'),
	(3, 0, 'refusals.per_domain.Demo EU'),
	(3, 1, 'documents.per_domain.MII.per_template.Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)2.0.a'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_Ergebnisse_erheblicher_Bedeutung1.0.per_status.UNKNOWN'),
	(3, 1, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Rekontaktierung Folgestudie1.0.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Collect Medical Data1.0.per_status.DECLINED'),
	(3, 0, 'qc.per_domain.Demo Deutschland.per_qctype.checked_major_faults'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Biomaterial erheben1.0.per_status.UNKNOWN'),
	(3, 4, 'withdrawals'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_lagern_verarbeiten1.0.per_status.ACCEPTED'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_weitere_Studien1.1.per_status.ACCEPTED'),
	(3, 2, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Identifizierende Daten speichern1.0.per_status.ACCEPTED'),
	(3, 2, 'informed_consents.per_domain.Demo EU'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_retro_speichern_verarbeiten1.1.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_pro_wissenschaftlich_nutzen1.0.per_status.UNKNOWN'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_retro_wissenschaftlich_nutzen1.0.per_status.DECLINED'),
	(3, 1, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Store Biomaterial1.0.per_status.DECLINED'),
	(3, 1, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Biomaterial lagern1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Medizinische Daten erheben1.0.per_status.DECLINED'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_erheben1.0.per_status.ACCEPTED'),
	(3, 0, 'qc.per_domain.MII.per_qctype.checked_major_faults'),
	(3, 0, 'qc.per_domain.MII.per_qctype.###_auto_generated_###'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_pro_uebertragen1.0.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_KVNR_5J_pro_uebertragen1.0.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_speichern_verarbeiten1.0.per_status.UNKNOWN'),
	(3, 3, 'qc.per_domain.MII.per_qctype.not_checked'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_Analysedaten_zusammenfuehren_Dritte1.1.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Biomaterial lagern1.0.per_status.UNKNOWN'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_retro_speichern_verarbeiten1.1.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_pro_uebertragen1.0.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Medizinische Daten speichern1.0.per_status.UNKNOWN'),
	(3, 35, 'modules_with_versions'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Rekontaktierung Folgestudie1.0.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_Zusatzbefund1.0.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Identifizierende Daten speichern1.0.per_status.DECLINED'),
	(3, 3, 'qc.per_domain.Demo EU.per_qctype.not_checked'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_retro_wissenschaftlich_nutzen1.0.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Medizinische Daten erheben1.0.per_status.UNKNOWN'),
	(3, 4, 'documents.per_domain.MII.per_template.Patienteneinwilligung MII1.6.d'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_Zusatzmengen_entnehmen1.0.per_status.UNKNOWN'),
	(3, 1, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Rekontaktierung Folgestudie1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_Analysedaten_zusammenfuehren_Dritte1.1.per_status.UNKNOWN'),
	(3, 3, 'documents_with_digital_patientsignature.per_domain.Demo EU'),
	(3, 1, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Share Biomaterial1.0.per_status.DECLINED'),
	(3, 2, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Store Medical Data1.0.per_status.ACCEPTED'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_Zusatzmengen_entnehmen1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Medizinische Daten speichern1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_Zusatzbefund1.0.per_status.ACCEPTED'),
	(3, 2, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Collect Medical Data1.0.per_status.ACCEPTED'),
	(3, 1, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Collect Biomaterial1.0.per_status.DECLINED'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_KVNR_5J_pro_uebertragen1.0.per_status.ACCEPTED'),
	(3, 2, 'withdrawals.per_domain.MII'),
	(3, 27, 'policies.per_domain.MII'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_pro_speichern_verarbeiten1.0.per_status.UNKNOWN'),
	(3, 1, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Collect Biomaterial1.0.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_KVNR_5J_retro_uebertragen1.0.per_status.UNKNOWN'),
	(3, 3, 'documents_with_digital_patientsignature.per_domain.Demo Deutschland'),
	(3, 0, 'refusals.per_domain.Demo Deutschland'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Store Biomaterial1.0.per_status.UNKNOWN'),
	(3, 2, 'informed_consents.per_domain.Demo Deutschland'),
	(3, 2, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Medizinische Daten herausgeben1.0.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_speichern_verarbeiten1.0.per_status.DECLINED'),
	(3, 1, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Recontact Follow Up Study1.0.per_status.ACCEPTED'),
	(3, 9, 'policies.per_domain.Demo Deutschland'),
	(3, 2, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Medizinische Daten speichern1.0.per_status.ACCEPTED'),
	(3, 4, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_Zusatzbefund1.0.per_status.DECLINED'),
	(3, 2, 'qc.per_domain.Demo Deutschland.per_qctype.checked_no_faults'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_zusammenfuehren_Dritte1.0.per_status.DECLINED'),
	(3, 0, 'qc.per_domain.Demo EU.per_qctype.###_auto_generated_###'),
	(3, 0, 'qc_invalid.per_domain.MII'),
	(3, 0, 'documents_expired_full.per_domain.Demo Deutschland'),
	(3, 846, 'calculation_time'),
	(3, 7, 'templates'),
	(3, 0, 'qc.per_domain.Demo Deutschland.per_qctype.invalidated'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_speichern_verarbeiten1.0.per_status.DECLINED'),
	(3, 11, 'documents_with_digital_patientsignature'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_weitere_Erhebung1.1.per_status.UNKNOWN'),
	(3, 5, 'documents_with_digital_patientsignature.per_domain.MII'),
	(3, 4, 'modules_with_versions.per_domain.Demo EU'),
	(3, 27, 'modules_with_versions.per_domain.MII'),
	(3, 2, 'templates.per_domain.Demo EU'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_Verknuepfung_Datenbanken1.0.per_status.DECLINED'),
	(3, 4, 'modules_with_versions.per_domain.Demo Deutschland'),
	(3, 3, 'documents_with_scans'),
	(3, 2, 'documents.per_domain.Demo EU.per_template.Consent Demostudy1.0'),
	(3, 1, 'withdrawals.per_domain.Demo Deutschland'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Collect Identifying Data1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Identifizierende Daten erheben1.0.per_status.UNKNOWN'),
	(3, 1, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Share Biomaterial1.0.per_status.ACCEPTED'),
	(3, 4, 'signer_ids.per_domain.MII.per_idtype.Pseudonym'),
	(3, 0, 'documents_expired_full.per_domain.Demo EU'),
	(3, 1, 'documents.per_domain.MII.per_template.Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)2.0.a'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_zusammenfuehren_Dritte1.0.per_status.DECLINED'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_pro_wissenschaftlich_nutzen1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_Ergebnisse_erheblicher_Bedeutung1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_Verknuepfung_Datenbanken1.0.per_status.UNKNOWN'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_erheben1.1.per_status.DECLINED'),
	(3, 2, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_wissenschaftlich_nutzen_EU_DSGVO_konform1.0.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_weitere_Studien1.1.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_zusammenfuehren_Dritte1.0.per_status.UNKNOWN'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_KVNR_5J_retro_uebertragen1.0.per_status.ACCEPTED'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_pro_speichern_verarbeiten1.0.per_status.DECLINED'),
	(3, 1, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Biomaterial erheben1.0.per_status.ACCEPTED'),
	(3, 2, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Share Medical Data1.0.per_status.ACCEPTED'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_erheben1.0.per_status.DECLINED'),
	(3, 1, 'documents.per_domain.Demo Deutschland.per_template.Widerruf Datenerhebung1.0'),
	(3, 0, 'documents_with_scans.per_domain.Demo Deutschland'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_weitere_Erhebung1.1.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Collect Identifying Data1.0.per_status.UNKNOWN'),
	(3, 2, 'documents.per_domain.Demo Deutschland.per_template.Einwilligung Demostudie1.0'),
	(3, 1, 'qc.per_domain.MII.per_qctype.checked_minor_faults'),
	(3, 4, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_Ergebnisse_erheblicher_Bedeutung1.0.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Store Medical Data1.0.per_status.UNKNOWN'),
	(3, 1, 'qc.per_domain.Demo Deutschland.per_qctype.checked_minor_faults'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Biomaterial herausgeben1.0.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_zusammenfuehren_Dritte1.0.per_status.UNKNOWN'),
	(3, 3, 'domains'),
	(3, 4, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_erheben1.1.per_status.ACCEPTED'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_Eigentum_uebertragen1.0.per_status.ACCEPTED'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform1.0.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Medizinische Daten herausgeben1.0.per_status.DECLINED'),
	(3, 2, 'qc.per_domain.MII.per_qctype.checked_no_faults'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_retro_uebertragen1.0.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Share Medical Data1.0.per_status.UNKNOWN'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.BIOMAT_erheben1.1.per_status.ACCEPTED'),
	(3, 4, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_speichern_verarbeiten1.0.per_status.ACCEPTED'),
	(3, 1, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.Rekontaktierung_weitere_Erhebung1.1.per_status.ACCEPTED'),
	(3, 45, 'policies'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Recontact Follow Up Study1.0.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_erheben1.1.per_status.UNKNOWN'),
	(3, 3, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_5J_retro_uebertragen1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Share Medical Data1.0.per_status.DECLINED'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_KVNR_5J_pro_uebertragen1.0.per_status.DECLINED'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Collect Medical Data1.0.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Identifizierende Daten speichern1.0.per_status.UNKNOWN'),
	(3, 0, 'signer_ids.per_domain.Demo EU.per_idtype.Study-ID.per_policy.Store Identifying Data1.0.per_status.DECLINED'),
	(3, 0, 'qc_invalid.per_domain.Demo EU'),
	(3, 4, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.MDAT_wissenschaftlich_nutzen_EU_DSGVO_konform1.0.per_status.ACCEPTED'),
	(3, 4, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.IDAT_zusammenfuehren_Dritte1.0.per_status.ACCEPTED'),
	(3, 3, 'documents_with_scans.per_domain.MII'),
	(3, 2, 'signer_ids.per_domain.MII.per_idtype.Pseudonym.per_policy.KKDAT_KVNR_5J_retro_uebertragen1.0.per_status.DECLINED'),
	(3, 1, 'signer_ids.per_domain.Demo Deutschland.per_idtype.Pseudonym.per_policy.Identifizierende Daten erheben1.0.per_status.DECLINED');

-- Exportiere Daten aus Tabelle gics.text: ~91 rows (ungefähr)
INSERT IGNORE INTO `text` (`ID`, `TEXT`) VALUES
	('Demo Deutschland_###_Biomaterial_###_1000_###_MODUL', '<div>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita <u>kasd gubergren</u>, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</div>'),
	('Demo Deutschland_###_Biomaterial_###_1000_###_MODULE_TITLE', '<div><strong>Biomaterial</strong></div>'),
	('Demo Deutschland_###_Datenschutzerklärung_###_1000_###_MODUL', '<div>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</div>'),
	('Demo Deutschland_###_Datenschutzerklärung_###_1000_###_MODULE_TITLE', '<div><strong>Datenschutzerklärung</strong></div>'),
	('Demo Deutschland_###_Einwilligung Demostudie_###_1000_###_FOOTER', ''),
	('Demo Deutschland_###_Einwilligung Demostudie_###_1000_###_HEADER', ''),
	('Demo Deutschland_###_Einwilligung Demostudie_###_1000_###_TEMPLATE_TITLE', '<h2 style="text-align: center;">Einwilligung zur Demostudie</h2>'),
	('Demo Deutschland_###_Rekontaktierung_###_1000_###_MODUL', '<div>Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</div>'),
	('Demo Deutschland_###_Rekontaktierung_###_1000_###_MODULE_TITLE', '<div><strong>Folgestudie</strong></div>'),
	('Demo Deutschland_###_Widerruf Datenerhebung_###_1000_###_FOOTER', ''),
	('Demo Deutschland_###_Widerruf Datenerhebung_###_1000_###_HEADER', ''),
	('Demo Deutschland_###_Widerruf Datenerhebung_###_1000_###_MODUL', '<div>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</div>'),
	('Demo Deutschland_###_Widerruf Datenerhebung_###_1000_###_MODULE_TITLE', '<div><strong>Widerruf Datenerhebung</strong></div>'),
	('Demo Deutschland_###_Widerruf Datenerhebung_###_1000_###_TEMPLATE_TITLE', '<h2 style="text-align: center;">Widerruf der Datenerhebung in der Demostudie</h2>'),
	('Demo EU_###_Biomaterial_###_1000_###_MODUL', '<div>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</div>'),
	('Demo EU_###_Biomaterial_###_1000_###_MODULE_TITLE', '<div><strong>Biomaterial</strong></div>'),
	('Demo EU_###_Consent Demostudy_###_1000_###_FOOTER', ''),
	('Demo EU_###_Consent Demostudy_###_1000_###_HEADER', ''),
	('Demo EU_###_Consent Demostudy_###_1000_###_TEMPLATE_TITLE', '<h2 style="text-align: center;">Consent for Demostudy</h2>'),
	('Demo EU_###_Privacy Statement_###_1000_###_MODUL', '<div>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</div>'),
	('Demo EU_###_Privacy Statement_###_1000_###_MODULE_TITLE', '<div><strong>Privacy Statement</strong></div>'),
	('Demo EU_###_Recontact_###_1000_###_MODUL', '<div>&nbsp;Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</div>'),
	('Demo EU_###_Recontact_###_1000_###_MODULE_TITLE', '<div><strong>Recontact</strong></div>'),
	('Demo EU_###_Withdrawal Data Collection_###_1000_###_FOOTER', ''),
	('Demo EU_###_Withdrawal Data Collection_###_1000_###_HEADER', ''),
	('Demo EU_###_Withdrawal Data Collection_###_1000_###_MODUL', '<div>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</div>'),
	('Demo EU_###_Withdrawal Data Collection_###_1000_###_MODULE_TITLE', '<div><strong>Withdrawal Data Collection</strong></div>'),
	('Demo EU_###_Withdrawal Data Collection_###_1000_###_TEMPLATE_TITLE', '<h2 style="text-align: center;">Withdrawal of data collection in Demostudy</h2>'),
	('MII_###_BIOMAT_Erhebungsende_###_2000_###_MODUL', '<div style="text-align: justify;"><strong><u>zukünftige </u>wissenschaftliche Nutzung von Biomaterialien</strong></div><div style="text-align: justify;">Hiermit widerrufe ich dier von mir gegebene Einwilligung zur wissenschaftlichen Nutzung meiner zukünftig im Behandlungskontext anfallenden Biomaterialien wie in Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Einwilligungserklärung/Patienteninformation des Standortes]</span> der Einwilligungserklärung und Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Einwilligungserklärung/Patienteninformation des Standortes]</span> der Patienteninformation beschrieben. Bereits entnommene Biomaterialien dürfen für wissenschaftliche Forschungszwecke weiterhin gelagert und genutzt werden.</div>'),
	('MII_###_BIOMAT_Erhebungsende_###_2000_###_MODULE_TITLE', '<div><br></div>'),
	('MII_###_BIOMAT_Intro_###_1006_###_MODUL', '<div style="text-align: justify;"><strong>3.1 </strong>die Lagerung und Verarbeitung meiner Biomaterialien in [<span style="background-color: rgb(240, 102, 102);">der/dem Träger der Biobank(en) bzw. Archive</span>] für medizinische Forschungszwecke ausschließlich wie in der Patienteninformation beschrieben und mit getrennter Verwaltung des Namens und anderer direkt identifizierender Daten (Codierung, siehe Punkte 3.1 bis 3.3 der Patienteninformation).</div><div style="text-align: justify;"><br></div><div style="text-align: justify;"><strong>3.2 </strong>die wissenschaftliche Analyse meiner codierten Biomaterialien sowie deren Weitergabe und Nutzung durch Dritte z.B. Universitäten/Institute/forschende Unternehmen für genauer bestimmte und beantragte medizinische Forschungszwecke; dies kann auch eine Weitergabe für Forschungsprojekte im Ausland umfassen, wenn in diesen europäisches Datenschutzrecht gilt oder die Europäische Kommission ein angemessenes Datenschutzniveau bestätigt hat. Vor einer Weitergabe an Forscher außerhalb meiner behandelnden Einrichtung erfolgt zudem eine weitere Ersetzung des internen Kennzeichens durch eine neue Zeichenkombination.</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Ebenso willige ich in die Möglichkeit einer Zusammenführung von Analyse-Daten meiner Biomaterialien mit Analyse-Daten in Datenbanken anderer Forschungspartner ein. <strong>Voraussetzung ist, dass ich dieser Nutzung bei den entsprechenden Forschungspartnern auch zugestimmt habe.</strong></div><div style="text-align: justify;"><br></div><div style="text-align: justify;"><strong>3.3 Das Eigentum an meinen Biomaterialien übertrage ich an [</strong><strong style="background-color: rgb(240, 102, 102);">den/die/das Träger der Biobank(en) bzw. Archive</strong><strong>]</strong>. Mein Recht, über die Verarbeitung meiner dem Biomaterial zu entnehmenden personenbezogenen Daten selbst zu bestimmen, bleibt von der Eigentumsübertragung unberührt (siehe Punkt 3.3 der Patienteninformation).</div><div><br></div>'),
	('MII_###_BIOMAT_Intro_###_1006_###_MODULE_TITLE', '<h3 style="text-align: justify;">3. Gewinnung, Lagerung und wissenschaftliche Nutzung meiner Biomaterialien (Gewebe und Körperflüssigkeiten), wie in der Patienteninformation beschrieben; dies umfasst</h3>'),
	('MII_###_BIOMAT_Vernichtung_###_2000_###_MODUL', '<div style="text-align: justify;">Hiermit widerrufe ich vollständig die von mir gegebene Einwilligung in die Nutzung bereits vorhandener, noch anzufordernder (retrospektiver), sowie zukünftiger Biomaterialien (Gewebe und Körperflüssigkeiten) für medizinische Forschungszwecke (Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Einwilligungserklärung des Standortes]</span> der Einwilligungserklärung und Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Patienteninformation des Standortes]</span> der Patienteninformation). Alle Proben, die von mir in diesem Rahmen gelagert wurden, sollen vernichtet werden.</div>'),
	('MII_###_BIOMAT_Vernichtung_###_2000_###_MODULE_TITLE', '<h3>Komplette Vernichtung meiner Biomaterialien</h3>'),
	('MII_###_BIOMAT_Zusatzentnahme_###_1008_###_MODUL', '<div style="text-align: justify;">[<span style="background-color: rgb(240, 102, 102);">Falls zutreffend:</span> Meine Einwilligung umfasst auch die Entnahme geringer zusätzlicher Mengen von Biomaterial bei einer sowieso stattfindenden Routine-Blutentnahme oder -Punktion in den unter Punkt 3.2 der Patienteninformation beschriebenen Grenzen.</div>'),
	('MII_###_BIOMAT_Zusatzentnahme_###_1008_###_MODULE_TITLE', NULL),
	('MII_###_BIOMAT_Zusatzmengen_Erhebungsende_###_2000_###_MODUL', '<div style="text-align: justify;"><strong>Entnahme geringer zusätzlicher Mengen von Biomaterial</strong></div><div style="text-align: justify;">Hiermit widerrufe ich dier von mir gegebene Einwilligung zur Entnahme geringer zusätzlicher Mengen von Biomaterial bei einer ohnehin stattfindenden Routine-Blutentnahme oder -Punktion in den unter Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Einwilligungserklärung/Patienteninformation des Standortes]</span> der Patienteninformation beschriebenen Grenzen. Bereits entnommene Biomaterialien dürfen für wissenschaftliche Forschungszwecke weiterhin gelagert und genutzt werden.</div>'),
	('MII_###_BIOMAT_Zusatzmengen_Erhebungsende_###_2000_###_MODULE_TITLE', '<h3>Biomaterialien</h3>'),
	('MII_###_BIOMAT_erheben_lagern_nutzen_###_1008_###_MODUL', '<div style="text-align: justify;">Ich willige ein in die Gewinnung, Lagerung und wissenschaftliche Nutzung meiner <strong>Biomaterialien </strong>(Gewebe und Körperflüssigkeiten), wie in Punkt 3.1 bis 3.3 der Einwilligungserklärung und Punkt 3 der Patienteninformation beschrieben.</div>'),
	('MII_###_BIOMAT_erheben_lagern_nutzen_###_1008_###_MODULE_TITLE', NULL),
	('MII_###_Geltungsdauer_###_1006_###_MODUL', '<div style="text-align: justify;">Meine Einwilligung in die Erhebung von Patientendaten [<span style="background-color: rgb(240, 102, 102);">falls zutreffend</span>: und in die Gewinnung von Biomaterialien] bei Aufenthalten <span style="background-color: rgb(240, 102, 102);">[in der/im Name der behandelnden Einrichtung</span>] gilt für einen <strong>Zeitraum von fünf Jahren</strong> ab meiner Einwilligungserklärung. Sollte ich nach Ablauf von fünf Jahren wieder im [Universitätsklinikum] vorstellig werden, kann ich erneut meine Einwilligung erteilen. Die Nutzung der von mir erhobenen Daten [<span style="background-color: rgb(240, 102, 102);">falls zutreffend</span>: und gewonnenen Biomaterialien] bleibt über diesen Zeitraum hinaus zulässig (Punkt 5 der Patienteninformation). </div>'),
	('MII_###_Geltungsdauer_###_1006_###_MODULE_TITLE', '<h3 style="text-align: justify;">5. Geltungsdauer meiner Einwilligung</h3>'),
	('MII_###_KKDAT_Intro_###_1006_###_MODUL', '<div style="text-align: justify;">Hiermit ermächtige ich meine Krankenkasse auf Anforderung durch [<span style="background-color: rgb(240, 102, 102);">zuständige Stelle</span>] Daten über von mir in Anspruch genommene ärztliche Leistungen in der ambulanten Versorgung und bei stationären Aufenthalten, über verordnete Heil- und Hilfsmittel sowie Arzneimittel und Angaben zum Bereich Pflege an [<span style="background-color: rgb(240, 102, 102);">Name der behandelnden Einrichtung</span>] sowie in der Patienteninformation beschrieben, zu übermitteln, und zwar:</div><div><br></div>'),
	('MII_###_KKDAT_Intro_###_1006_###_MODULE_TITLE', '<h3 style="text-align: justify;">2. Übertragung und wissenschaftliche Nutzung meiner Krankenkassendaten</h3>'),
	('MII_###_KKDAT_Loeschung_###_2000_###_MODUL', '<div style="text-align: justify;">Hiermit widerrufe ich vollständig die von mir gegebene Einwilligung in die Nutzung bereits vorhandener, noch abzurufender (retrospektiver), sowie zukünftiger Krankenkassendaten für medizinische Forschungszwecke. Alle Krankenkassendaten, die von mir in diesem Rahmen gespeichert wurden, sollen gelöscht werden.</div>'),
	('MII_###_KKDAT_Loeschung_###_2000_###_MODULE_TITLE', '<h3>Komplette Löschung meiner Krankenkassendaten</h3>'),
	('MII_###_KKDAT_prospektiv_Uebertragungsende_###_2000_###_MODUL', '<div style="text-align: justify;"><strong>Übertragung von <u>zukünftig anfallenden</u> Krankenkassendaten an die </strong><strong style="color: rgb(230, 0, 0);">[zuständige Stelle]</strong></div><div style="text-align: justify;">Hiermit widerrufe ich die von mir gegebene Einwilligung zur Übertragung meiner zukünftig anfallenden Krankenkassendaten an die <span style="color: rgb(230, 0, 0);">[zuständige Stelle]</span>. Bereits übertragene Krankenkassendaten dürfen weiterhin genutzt werden.</div>'),
	('MII_###_KKDAT_prospektiv_Uebertragungsende_###_2000_###_MODULE_TITLE', '<h3>Krankenkassendaten</h3>'),
	('MII_###_KKDAT_prospektiv_uebertragen_speichern_nutzen_###_1008_###_MODUL', '<div style="text-align: justify;"><strong>2.2 </strong>Für Daten <strong>ab dem Datum meiner Unterschrift über einen Zeitraum von 5 Jahren</strong>. Mit der dafür nötigen Übermittlung meiner Krankenversicherungsnummer. an <span style="background-color: rgb(240, 102, 102);">[zuständige Stelle]</span> bin ich einverstanden.</div>'),
	('MII_###_KKDAT_prospektiv_uebertragen_speichern_nutzen_###_1008_###_MODULE_TITLE', NULL),
	('MII_###_KKDAT_retrospektiv_Uebertragungsende_###_2000_###_MODUL', '<div><strong>Übertragung <u>bereits angefallener</u> Krankenkassendaten an die </strong><strong style="color: rgb(230, 0, 0);">[zuständige Stelle]</strong></div><div style="text-align: justify;">Hiermit widerrufe ich die von mir gegebene Einwilligung zur (einmaligen) Übertragung meiner Krankenkassendaten der vergangenen 5 Kalenderjahre an die <span style="color: rgb(230, 0, 0);">[zuständige Stelle]</span>. Die Verhinderung der Datenübertragung ist nur möglich, wenn diese noch nicht stattgefunden hat. Bereits übertragene Krankenkassendaten der vergangenen 5 Kalenderjahre dürfen weiterhin genutzt werden.</div>'),
	('MII_###_KKDAT_retrospektiv_Uebertragungsende_###_2000_###_MODULE_TITLE', '<div><br></div>'),
	('MII_###_KKDAT_retrospektiv_uebertragen_speichern_nutzen_###_1008_###_MODUL', '<div style="text-align: justify;"><strong>2.1 </strong>Einmalig <strong>rückwirkend für die Daten der vergangenen 5 Kalenderjahre</strong>. Mit der dafür nötigen Übermittlung meiner Krankenversicherungsnummer an <span style="background-color: rgb(240, 102, 102);">[zuständige Stelle]</span> bin ich einverstanden.</div>'),
	('MII_###_KKDAT_retrospektiv_uebertragen_speichern_nutzen_###_1008_###_MODULE_TITLE', NULL),
	('MII_###_Kontaktsperre_Informationen_wissenschaftliche_Fragen_neue_Studien_###_2000_###_MODUL', '<div style="text-align: justify;"><strong>Informationen zu wissenschaftlichen Fragen und neuen Studien</strong></div><div style="text-align: justify;">Hiermit widerrufe ich die von mir gegebene Einwilligung zur erneuten Kontaktaufnahme, um im Rahmen der MII künftig nicht mehr für Informationen zu wissenschaftlichen Fragen kontaktiert und über neue Forschungsvorhaben/Studien informiert zu werden (Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Einwilligungserklärung/Patienteninformation des Standortes]</span> der Einwilligungserklärung und Patienteninformation). Von Anfragen zur Verknüpfung meiner Patientendaten soll künftig abgesehen werden.</div>'),
	('MII_###_Kontaktsperre_Informationen_wissenschaftliche_Fragen_neue_Studien_###_2000_###_MODULE_TITLE', '<h3>Erneute Kontaktaufnahme</h3>'),
	('MII_###_Kontaktsperre_gesundheitsrelevante_Analyseergebnisse_###_2000_###_MODUL', '<div style="text-align: justify;"><strong>Informationen zu gesundheitsrelevanten Analyseergebnissen</strong></div><div style="text-align: justify;">Hiermit widerrufe ich die von mir gegebene Einwilligung zur Rekontaktierung, um im Rahmen der MII künftig nicht mehr über <strong>Analyseergebnisse, die möglicherweise für meine Gesundheit relevant sind (medizinische Zusatzbefunde)</strong> informiert zu werden (Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Einwilligungserklärung/Patienteninformation des Standortes]</span> der Einwilligungserklärung und Patienteninformation).</div>'),
	('MII_###_Kontaktsperre_gesundheitsrelevante_Analyseergebnisse_###_2000_###_MODULE_TITLE', NULL),
	('MII_###_PATDAT_BIOMAT_KKDAT_komplett_widerrufen_###_2000_###_MODUL', '<div style="text-align: justify;">Hiermit widerrufe ich vollständig die von mir gegebene Einwilligung in die Nutzung bereits vorhandener, noch zu übermittelnder (retrospektiver), sowie zukünftiger <strong>Patienten- und Krankenkassendaten</strong> (falls zutreffend) für medizinische Forschungszwecke (Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Einwilligungserklärung des Standortes]</span> der Einwilligungserklärung und Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Patienteninformation des Standortes]</span> der Patienteninformation). Alle Daten, die von mir in diesem Rahmen gespeichert wurden, sollen gelöscht werden.</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Darüber hinaus widerrufe ich vollständig die von mir gegebene Einwilligung in die Nutzung vorhandener, noch anzufordernder (retrospektiver), sowie zukünftig entnommener <strong>Biomaterialien </strong>(Gewebe und Körperflüssigkeiten) (falls zutreffend) für medizinische Forschungszwecke (Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Einwilligungserklärung des Standortes]</span> der Einwilligungserklärung und Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Patienteninformation des Standortes]</span> der Patienteninformation). Alle Proben, die von mir in diesem Rahmen gelagert wurden, sollen vernichtet werden.</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Weiterhin widerrufe ich die von mir gegebene Einwilligung zur <strong>Rekontaktierung</strong>, um im Rahmen der MII künftig nicht mehr über <strong>Analyseergebnisse, die möglicherweise für meine Gesundheit relevant sind (medizinische Zusatzbefunde)</strong>, zusätzliche wissenschaftliche Fragestellungen und neue Forschungsvorhaben/ Studien informiert zu werden (Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Einwilligungserklärung des Standortes]</span> der Einwilligungserklärung und Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Patienteninformation des Standortes]</span> der Patienteninformation). Von Anfragen zur Verknüpfung meiner Patientendaten soll künftig abgesehen werden.</div>'),
	('MII_###_PATDAT_BIOMAT_KKDAT_komplett_widerrufen_###_2000_###_MODULE_TITLE', '<h3><strong style="color: black;">Komplette Löschung meiner Patientendaten, Krankenkassendaten und Biomaterialien (falls zutreffend)</strong></h3>'),
	('MII_###_PATDAT_Erhebungsende_###_2000_###_MODUL', '<div style="text-align: justify;"><strong>Erhebung zukünftig anfallender Patientendaten</strong></div><div style="text-align: justify;">Hiermit widerrufe ich die von mir gegebene Einwilligung zur Erhebung meiner zukünftigen Patientendaten wie in Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Einwilligungserklärung des Standortes]</span> der Einwilligungserklärung und Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Patienteninformation des Standortes]</span> der Patienteninformation beschrieben. Bereits erhobene Daten dürfen im Gültigkeitszeitraum der Einwilligung weiterhin für wissenschaftliche Forschungszwecke gespeichert und genutzt werden.</div>'),
	('MII_###_PATDAT_Erhebungsende_###_2000_###_MODULE_TITLE', '<h3>Patientendaten</h3>'),
	('MII_###_PATDAT_Intro_###_1006_###_MODUL', '<div style="text-align: justify;"><strong>1.1 </strong>die Verarbeitung und Nutzung meiner Patientendaten für die medizinische Forschung ausschließlich wie in der Patienteninformation beschrieben und mit getrennter Verwaltung des Namens und anderer direkt identifizierender Daten (Codierung). Unter der Adresse <strong>www.medizininformatik-initiative.de/datennutzung</strong> kann ich mich für einen E-Mail-Verteiler registrieren, der per E-Mail über alle neuen Studien, die mit den Patientendaten durchgeführt werden, vor deren Durchführung informiert (siehe Punkte 1.1, 1.2 und 1.3 der Patienteninformation).</div><div style="text-align: justify;"><br></div><div style="text-align: justify;"><strong>1.2 </strong>die wissenschaftliche Analyse und Nutzung meiner codierten Patientendaten durch Dritte wie z.B. durch andere Universitäten/Institute/forschende Unternehmen; dies kann auch eine Weitergabe für Forschungsprojekte im Ausland umfassen, wenn in diesen europäisches Datenschutzrecht gilt oder die Europäische Kommission ein angemessenes Datenschutzniveau bestätigt hat. An einem etwaigen kommerziellen Nutzen aus der Forschung werde ich nicht beteiligt. Vor einer Weitergabe an Forscher außerhalb meiner behandelnden Einrichtung erfolgt zudem eine weitere Ersetzung des internen Kennzeichens durch eine neue Zeichenkombination.</div><div style="text-align: justify;"><br></div><div style="text-align: justify;"><strong>1.3 </strong>die Möglichkeit einer Zusammenführung meiner Patientendaten mit Daten in Datenbanken anderer Forschungspartner. <strong>Voraussetzung ist, dass ich dieser Nutzung bei den entsprechenden Forschungspartnern auch zugestimmt habe.</strong></div>'),
	('MII_###_PATDAT_Intro_###_1006_###_MODULE_TITLE', '<div><br></div><h3 style="text-align: justify;">1. Erhebung, Verarbeitung und wissenschaftliche Nutzung meiner Patientendaten, wie in der Patienteninformation beschrieben; dies umfasst</h3>'),
	('MII_###_PATDAT_Loeschung_###_2000_###_MODUL', '<div style="text-align: justify;">Hiermit widerrufe ich vollständig die von mir gegebene Einwilligung in die Nutzung bereits vorhandener, noch zu übermittelnder (retrospektiver), sowie zukünftiger Patientendaten für medizinische Forschungszwecke (Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Einwilligungserklärung des Standortes]</span> der Einwilligungserklärung und Punkt <span style="color: rgb(230, 0, 0);">[entsprechende Nummer in der Patienteninformation des Standortes]</span> der Patienteninformation). Alle Daten, die von mir in diesem Rahmen gespeichert wurden, sollen gelöscht werden.</div>'),
	('MII_###_PATDAT_Loeschung_###_2000_###_MODULE_TITLE', '<div><h3>Komplette Löschung meiner Patientendaten</h3></div>'),
	('MII_###_PATDAT_erheben_speichern_nutzen_###_1008_###_MODUL', '<div style="text-align: justify;">Ich willige ein in die Erhebung, Verarbeitung, Speicherung und wissenschaftliche Nutzung meiner <strong>Patientendaten </strong>wie in Punkt 1.1 bis 1.3 der Einwilligungserklärung und Punkt 1 der Patienteninformation beschrieben.</div>'),
	('MII_###_PATDAT_erheben_speichern_nutzen_###_1008_###_MODULE_TITLE', NULL),
	('MII_###_Patienteneinwilligung MII_###_1006003_###_FOOTER', ''),
	('MII_###_Patienteneinwilligung MII_###_1006003_###_HEADER', '<h2 style="text-align: justify;">Einwilligung in die Nutzung von Patientendaten, [<span style="background-color: rgb(240, 102, 102);">falls zutreffend</span>: Krankenkassendaten und Biomaterialien (Gewebe und Körperflüssigkeiten)] für medizinische Forschungszwecke</h2>'),
	('MII_###_Patienteneinwilligung MII_###_1006003_###_TEMPLATE_TITLE', '<h1>Einwilligungserklärung</h1>'),
	('MII_###_Rekontaktierung_Ergaenzungen_###_1007_###_MODUL', '<div style="text-align: justify;"><strong>4.1. </strong>Ich willige ein, dass ich von [<span style="background-color: rgb(240, 102, 102);">der/dem Name der behandelnden Einrichtung</span>] erneut kontaktiert werden darf, um gegebenenfalls zusätzliche für wissenschaftliche Fragen relevante Informationen [<span style="background-color: rgb(240, 102, 102);">falls zutreffend</span>: oder Biomaterialien] zur Verfügung zu stellen, um über neue Forschungsvorhaben/Studien informiert zu werden, und/oder um meine Einwilligung in die Verknüpfung meiner Patientendaten mit medizinischen Informationen aus anderen Datenbanken einzuholen (siehe Punkt 4.1 der Patienteninformation).</div>'),
	('MII_###_Rekontaktierung_Ergaenzungen_###_1007_###_MODULE_TITLE', NULL),
	('MII_###_Rekontaktierung_Intro_###_1006_###_MODUL', NULL),
	('MII_###_Rekontaktierung_Intro_###_1006_###_MODULE_TITLE', '<h3 style="text-align: justify;">4. Möglichkeit einer erneuten Kontaktaufnahme</h3>'),
	('MII_###_Rekontaktierung_Zusatzbefund_###_1008_###_MODUL', '<div style="text-align: justify;"><strong>4.2 </strong>Ich willige ein, dass ich von [<span style="background-color: rgb(240, 102, 102);">der/dem Name der behandelnden Einrichtung</span>] wieder kontaktiert werden darf, um über medizinische Zusatzbefunde informiert zu werden (siehe Punkt 4.2 der Patienteninformation).</div>'),
	('MII_###_Rekontaktierung_Zusatzbefund_###_1008_###_MODULE_TITLE', NULL),
	('MII_###_Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_FOOTER', ''),
	('MII_###_Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_HEADER', '<div><br></div>'),
	('MII_###_Teilwiderruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_TEMPLATE_TITLE', '<h2 style="text-align: center;"><strong>Teilwiderruf</strong> zur Einwilligungserklärung </h2><h2 style="text-align: center;">für die Medizininformatik-Initiative (MII)</h2>'),
	('MII_###_Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_FOOTER', '<div style="text-align: center;"><br></div>'),
	('MII_###_Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_HEADER', '<div style="text-align: center;"><br></div>'),
	('MII_###_Vollständiger Widerruf (kompatibel zu Patienteneinwilligung MII 1.6d)_###_2000000_###_TEMPLATE_TITLE', '<h2 style="text-align: center;"><strong>Vollständiger Widerruf</strong> zur Einwilligungserklärung </h2><h2 style="text-align: center;">für die Medizininformatik-Initiative (MII)</h2>'),
	('MII_###_Widerrufsintro_teilweise_###_1000_###_MODUL', '<div style="text-align: center;">Wenn Sie Ihre Einwilligungserklärung zur Nutzung von Patientendaten, Krankenkassendaten und Biomaterialien für medizinische Forschungszwecke in ausgewählten Punkten widerrufen möchten, füllen Sie bitte dieses Formular aus und senden es unterschrieben an:</div><div style="text-align: center;"><br></div><div style="text-align: center;"><span style="color: rgb(230, 0, 0);">[Adresse der zuständigen Stelle]</span></div><div style="text-align: center;"><span style="color: rgb(230, 0, 0);">E-Mail: [Mailadresse der zuständigen Stelle]</span></div><div style="text-align: center;"><span style="color: rgb(230, 0, 0);">Telefon und Fax: [Telefon und Fax der zuständigen Stelle]</span></div><div style="text-align: justify;"><br></div><div style="text-align: justify;"><strong>Liebe Patientin, lieber Patient,</strong></div><div style="text-align: justify;"><br></div><div style="text-align: justify;">mit diesem Widerrufsformular haben Sie die Möglichkeit, die von Ihnen erteilte Einwilligung in die Nutzung von Patientendaten <span style="color: rgb(230, 0, 0);">[falls zutreffend: Krankenkassendaten und Biomaterialien (Gewebe und Körperflüssigkeiten)]</span> für medizinische Forschungszwecke ganz oder in Teilen zu widerrufen.</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Natürlich respektieren wir Ihre Entscheidung sich ganz oder teilweise nicht mehr an der medizinischen Forschung beteiligen zu wollen und es entstehen Ihnen dadurch keine Nachteile in Hinblick auf Ihre aktuelle und zukünftige medizinische Behandlung in unserer Einrichtung.</div><div style="text-align: justify;">Bitte beachten Sie, dass sich ein Widerruf dabei immer nur auf die zukünftige Verwendung Ihrer Patientendaten und Biomaterialien bezieht. Daten aus bereits durchgeführten Analysen können nachträglich nicht mehr entfernt werden.</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Im Falle eines entsprechenden Widerrufs werden die von Ihnen für die Forschung zur Verfügung gestellten Biomaterialien vernichtet und Ihre auf Grundlage dieser Einwilligung gespeicherten Patientendaten gelöscht oder anonymisiert, sofern dies gesetzlich zulässig ist. Wenn eine Löschung nicht oder nicht mit zumutbarem technischem Aufwand möglich ist, werden Ihre Patientendaten anonymisiert, indem der Ihnen zugeordnete Identifizierungscode gelöscht wird. Die Anonymisierung Ihrer Patientendaten kann allerdings eine spätere Zuordnung von – insbesondere genetischen – Informationen zu Ihrer Person über andere Quellen niemals völlig ausschließen.</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Auf den folgenden Seiten haben Sie die Möglichkeit, zum Beispiel ausschließlich die Kontaktierung durch uns zu beenden und/ oder künftig keine weiteren medizinischen Daten, Biomaterialien und/ oder Krankenkassendaten an uns weiterzugeben.</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Möglichkeiten Ihre Einwilligungserklärung zu widerrufen:</div><div><br></div>'),
	('MII_###_Widerrufsintro_teilweise_###_1000_###_MODULE_TITLE', NULL),
	('MII_###_Widerrufsintro_vollstaendig_###_1000_###_MODUL', '<div style="text-align: center;">Wenn Sie Ihre Einwilligungserklärung zur Nutzung von Patientendaten, Krankenkassendaten und Biomaterialien für medizinische Forschungszwecke in allen Punkten und somit vollständig widerrufen möchten, füllen Sie bitte dieses Formular aus und senden es unterschrieben an:</div><div style="text-align: center;"><br></div><div style="text-align: center;"><span style="color: rgb(230, 0, 0);">[Adresse der zuständigen Stelle]</span></div><div style="text-align: center;"><span style="color: rgb(230, 0, 0);">E-Mail: [Mailadresse der zuständigen Stelle]</span></div><div style="text-align: center;"><span style="color: rgb(230, 0, 0);">Telefon und Fax: [Telefon und Fax der zuständigen Stelle]</span></div><div style="text-align: justify;"><br></div><div style="text-align: justify;"><strong>Liebe Patientin, lieber Patient,</strong></div><div style="text-align: justify;"><br></div><div style="text-align: justify;">mit diesem Widerrufsformular haben Sie die Möglichkeit, die von Ihnen erteilte Einwilligung in die Nutzung von Patientendaten <span style="color: rgb(230, 0, 0);">[falls zutreffend: Krankenkassendaten und Biomaterialien (Gewebe und Körperflüssigkeiten)]</span> für medizinische Forschungszwecke komplett zu widerrufen.</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Natürlich respektieren wir Ihre Entscheidung sich nicht mehr an der medizinischen Forschung beteiligen zu wollen und es entstehen Ihnen dadurch keine Nachteile in Hinblick auf Ihre aktuelle und zukünftige medizinische Behandlung in unserer Einrichtung.</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Da die medizinische Forschung in Deutschland jedoch stark auf die freiwillige Teilnahme von Patientinnen und Patienten angewiesen ist, möchten wir Sie bitten, eine komplette Löschung Ihrer Daten nur als letztes Mittel der Wahl auszulösen. Sie haben alternativ zum Beispiel die Möglichkeiten, ausschließlich die Kontaktierung durch uns zu beenden und/oder in der Zukunft keine weiteren medizinischen Daten, Biomaterialien und/oder Krankenkassendaten an uns weiterzugeben. Hierfür nutzen Sie bitte das Formular <em>„Teilwiderruf zur Einwilligungserklärung für die Medizininformatik-Initiative (MII)“</em>.</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Bitte beachten Sie, dass sich ein Widerruf immer nur auf die zukünftige Verwendung Ihrer Patientendaten und Biomaterialien bezieht. Daten aus bereits durchgeführten Analysen können nachträglich nicht mehr entfernt werden.</div><div style="text-align: justify;">Im Falle eines entsprechenden Widerrufs werden die von Ihnen für die Forschung zur Verfügung gestellten Biomaterialien vernichtet und Ihre auf Grundlage dieser Einwilligung gespeicherten Patientendaten gelöscht oder anonymisiert, sofern dies gesetzlich zulässig ist. Wenn eine Löschung nicht oder nicht mit zumutbarem technischem Aufwand möglich ist, werden Ihre Patientendaten anonymisiert, indem der Ihnen zugeordnete Identifizierungscode gelöscht wird. Die Anonymisierung Ihrer Patientendaten kann allerdings eine spätere Zuordnung von – insbesondere genetischen – Informationen zu Ihrer Person über andere Quellen niemals völlig ausschließen.</div><div style="text-align: justify;"><br></div><div><br></div>'),
	('MII_###_Widerrufsintro_vollstaendig_###_1000_###_MODULE_TITLE', NULL),
	('MII_###_Widerrufsrecht_###_1006_###_MODUL', '<div style="text-align: justify;">Meine Einwilligung ist <strong>freiwillig</strong>!</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Ich kann meine Einwilligung jederzeit ohne Angabe von Gründen bei <span style="background-color: rgb(240, 102, 102);">[der/dem Name der behandelnden Einrichtung]</span> vollständig oder in Teilen widerrufen, ohne dass mir irgendwelche Nachteile entstehen.&nbsp;</div><div style="text-align: justify;"><br></div><div style="text-align: justify;">Beim Widerruf werden [<span style="background-color: rgb(240, 102, 102);">falls zutreffend</span>: die für die Forschung verbliebenen Biomaterialien und] die auf Grundlage dieser Einwilligung gespeicherten Daten <span style="background-color: rgb(240, 102, 102);">[falls zutreffend</span>: vernichtet bzw.] gelöscht oder anonymisiert, sofern dies gesetzlich zulässig ist. Daten aus bereits durchgeführten Analysen können nicht mehr entfernt werden (Punkt 6 der Patienteninformation).</div><div style="text-align: justify;"><br></div><div style="text-align: justify;"><strong>Ich wurde über die Nutzung meiner Patientendaten [</strong><strong style="background-color: rgb(240, 102, 102);">falls zutreffend:</strong><strong>, Krankenkassendaten und Biomaterialien] sowie die damit verbundenen Risiken informiert und erteile im vorgenannten Rahmen meine Einwilligung. Ich hatte ausreichend Bedenkzeit und alle meine Fragen wurden zufriedenstellend beantwortet.</strong></div><div style="text-align: justify;"><br></div><div style="text-align: justify;"><strong>Ich wurde darüber informiert, dass ich ein Exemplar der Patienteninformation und eine Kopie der unterschriebenen Einwilligungserklärung erhalten werde.</strong></div>'),
	('MII_###_Widerrufsrecht_###_1006_###_MODULE_TITLE', '<div style="text-align: justify;"><br></div><h3 style="text-align: justify;">6. Widerrufsrecht</h3>'),
	('MII_###_Widerrufsvermerk_###_1000_###_MODUL', '<div style="text-align: justify;"><strong>Um den Widerruf zu vermerken, verbleibt in der </strong><strong style="color: rgb(230, 0, 0);">[zuständige Stelle]</strong><strong> das Widerrufsformular, sowie die Dokumentation über die erfolgte Umsetzung des Widerrufs (Datenlöschung und Probenvernichtung).</strong></div>'),
	('MII_###_Widerrufsvermerk_###_1000_###_MODULE_TITLE', NULL);

-- Exportiere Daten aus Tabelle gics.virtual_person: ~0 rows (ungefähr)
INSERT IGNORE INTO `virtual_person` (`ID`, `CREATE_TIMESTAMP`) VALUES
	(1, '2022-02-01 09:16:49.161'),
	(2, '2022-02-01 09:17:38.246'),
	(3, '2022-02-01 09:21:16.356'),
	(4, '2022-02-01 09:22:33.390'),
	(5, '2022-02-01 09:27:24.164'),
	(6, '2022-02-01 09:30:19.385'),
	(7, '2022-02-01 09:31:40.645'),
	(8, '2022-02-01 09:55:08.242');

-- Exportiere Daten aus Tabelle gics.virtual_person_signer_id: ~0 rows (ungefähr)
INSERT IGNORE INTO `virtual_person_signer_id` (`SIT_NAME`, `SIT_DOMAIN_NAME`, `SI_VALUE`, `VP_ID`) VALUES
	('Pseudonym', 'Demo Deutschland', 'S-00001', 1),
	('Pseudonym', 'Demo Deutschland', 'S-00002', 2),
	('Pseudonym', 'MII', 'dic_1H51T', 5),
	('Pseudonym', 'MII', 'dic_61C5X', 6),
	('Pseudonym', 'MII', 'dic_810MT', 8),
	('Pseudonym', 'MII', 'dic_R3M0V3', 7),
	('Study-ID', 'Demo EU', 'S-00101', 3),
	('Study-ID', 'Demo EU', 'S-00102', 4);

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
