ALTER TABLE `consent` CHANGE `PHYSICANID` `PHYSICIANID` varchar(255);


-- Consent
ALTER TABLE `consent`
	ADD CREATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD UPDATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD VALID_FROM datetime(3),
	ADD VALID_TO datetime(3);

UPDATE `consent`
	SET CREATE_TIMESTAMP = CONSENT_DATE,
		UPDATE_TIMESTAMP = CONSENT_DATE;


-- consent_template
ALTER TABLE `consent_template` CHANGE `PROPERTIES` `EXPIRATION_PROPERTIES` varchar(255);

ALTER TABLE `consent_template`
	ADD CREATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD UPDATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD LABEL varchar(255),
	ADD FINALISED TINYINT(1);

UPDATE `consent_template`
	SET CREATE_TIMESTAMP = '1970-01-02 00:00:01',
		UPDATE_TIMESTAMP = '1970-01-02 00:00:01',
		LABEL = NAME
    WHERE LABEL IS NULL;

UPDATE `consent_template` ct
SET FINALISED = 0
WHERE FINALISED IS NULL
  AND NOT EXISTS (
        SELECT *
        FROM consent c
        WHERE c.CT_DOMAIN_NAME = ct.DOMAIN_NAME
          AND c.CT_NAME = ct.NAME
          AND c.CT_VERSION = ct.VERSION);

UPDATE `consent_template` ct
SET FINALISED = 1
WHERE FINALISED IS NULL
  AND EXISTS (
        SELECT *
        FROM consent c
        WHERE c.CT_DOMAIN_NAME = ct.DOMAIN_NAME
          AND c.CT_NAME = ct.NAME
          AND c.CT_VERSION = ct.VERSION);

-- domain
ALTER TABLE `domain`
	ADD FINALISED TINYINT(1),
	ADD CREATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD UPDATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3);

UPDATE `domain`
	SET CREATE_TIMESTAMP = '1970-01-02 00:00:01',
		UPDATE_TIMESTAMP = '1970-01-02 00:00:01',
		FINALISED = 1
    WHERE FINALISED IS NULL;


-- free_text_def
ALTER TABLE `free_text_def`
	ADD CREATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD UPDATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD FINALISED TINYINT(1);

UPDATE `free_text_def`
	SET CREATE_TIMESTAMP = '1970-01-02 00:00:01',
		UPDATE_TIMESTAMP = '1970-01-02 00:00:01'
    WHERE FINALISED IS NULL;

UPDATE `free_text_def` f
SET FINALISED = 0
WHERE FINALISED IS NULL
  AND NOT EXISTS (
        SELECT *
        FROM consent c
        WHERE c.CT_DOMAIN_NAME = f.DOMAIN_NAME
          AND c.CT_NAME = f.CT_NAME
          AND c.CT_VERSION = f.CT_VERSION);

UPDATE `free_text_def` f
SET FINALISED = 1
WHERE FINALISED IS NULL
  AND EXISTS (
        SELECT *
        FROM consent c
        WHERE c.CT_DOMAIN_NAME = f.DOMAIN_NAME
          AND c.CT_NAME = f.CT_NAME
          AND c.CT_VERSION = f.CT_VERSION);


-- module
ALTER TABLE `module`
	ADD CREATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD UPDATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD LABEL varchar(255),
	ADD FINALISED TINYINT(1);

UPDATE `module`
	SET CREATE_TIMESTAMP = '1970-01-02 00:00:01',
		UPDATE_TIMESTAMP = '1970-01-02 00:00:01',
		LABEL = NAME
    WHERE LABEL IS NULL;

UPDATE `module` m
SET FINALISED = 0
WHERE FINALISED IS NULL
  AND NOT EXISTS (
        SELECT *
        FROM consent c, module_consent_template mc
        WHERE c.CT_DOMAIN_NAME = mc.CT_DOMAIN
          AND c.CT_NAME = mc.CT_NAME
          AND c.CT_VERSION = mc.CT_VERSION
			 AND mc.M_DOMAIN = m.DOMAIN_NAME
			 AND mc.M_NAME = m.NAME
			 AND mc.M_VERSION = m.VERSION);

UPDATE `module` m
SET FINALISED = 1
WHERE FINALISED IS NULL
  AND EXISTS (
        SELECT *
        FROM consent c, module_consent_template mc
        WHERE c.CT_DOMAIN_NAME = mc.CT_DOMAIN
          AND c.CT_NAME = mc.CT_NAME
          AND c.CT_VERSION = mc.CT_VERSION
			 AND mc.M_DOMAIN = m.DOMAIN_NAME
			 AND mc.M_NAME = m.NAME
			 AND mc.M_VERSION = m.VERSION);


-- module_consent_template
ALTER TABLE `module_consent_template`
	ADD EXPIRATION_PROPERTIES varchar(255);


-- policy
ALTER TABLE `policy`
	ADD CREATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD UPDATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD LABEL varchar(255),
	ADD FINALISED TINYINT(1);

UPDATE `policy`
	SET CREATE_TIMESTAMP = '1970-01-02 00:00:01',
		UPDATE_TIMESTAMP = '1970-01-02 00:00:01',
		LABEL = NAME,
		FINALISED = 1
    WHERE FINALISED IS NULL;


-- signer_id
ALTER TABLE `signer_id`
	ADD CREATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3);

UPDATE `signer_id`
	SET CREATE_TIMESTAMP = '1970-01-02 00:00:01';


-- signer_id_type
ALTER TABLE `signer_id_type`
	ADD LABEL varchar(255),
	ADD COMMENT varchar(255),
	ADD CREATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	ADD UPDATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3);

UPDATE `signer_id_type`
	SET CREATE_TIMESTAMP = '1970-01-02 00:00:01',
		UPDATE_TIMESTAMP = '1970-01-02 00:00:01',
		LABEL = NAME
    WHERE LABEL IS NULL;


-- virtual_person
ALTER TABLE `virtual_person`
	ADD CREATE_TIMESTAMP timestamp(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3);

UPDATE `virtual_person`
	SET CREATE_TIMESTAMP = '1970-01-02 00:00:01';

UPDATE `domain`
	SET LABEL = NAME WHERE LABEL IS NULL OR LABEL = '';
