SET @default_qs_state := '###_auto_generated_###';

-- copy template title to text table
INSERT INTO `text` (ID, TEXT)
SELECT CONCAT(DOMAIN_NAME, '_###_', NAME,'_###_', VERSION, '_###_TEMPLATE_TITLE'), title
FROM consent_template;

-- copy module title to text table
INSERT INTO `text` (ID, TEXT)
SELECT CONCAT(DOMAIN_NAME, '_###_', NAME,'_###_', VERSION, '_###_MODULE_TITLE'), title
FROM module;

-- update template title reference to text table
UPDATE consent_template
SET TITLE = CONCAT(DOMAIN_NAME, '_###_', NAME,'_###_', VERSION, '_###_TEMPLATE_TITLE');

-- update module title reference to text table
UPDATE module
SET TITLE = CONCAT(DOMAIN_NAME, '_###_', NAME,'_###_', VERSION, '_###_MODULE_TITLE');

-- fix older workaround for title length in some projects
ALTER TABLE `consent_template`
	CHANGE COLUMN `TITLE` `TITLE` VARCHAR(255) NULL DEFAULT NULL FIRST;
ALTER TABLE `module`
	CHANGE COLUMN `TITLE` `TITLE` VARCHAR(255) NULL DEFAULT NULL AFTER `EXTERN_PROPERTIES`;

ALTER TABLE consent_template
ADD CONSTRAINT FK_consent_template_TITLE
FOREIGN KEY (TITLE)
REFERENCES text(ID)
;
ALTER TABLE module
ADD CONSTRAINT FK_module_TITLE
FOREIGN KEY (TITLE)
REFERENCES text(ID)
;
CREATE INDEX I_FK_consent_template_TITLE ON consent_template(TITLE)
;
CREATE INDEX I_FK_module_TITLE ON consent_template(TITLE)
;

ALTER TABLE module
ADD COLUMN SHORT_TEXT varchar(5000) NULL;


-- start remove unused suffixes
ALTER TABLE consent
DROP FOREIGN KEY FK_consent_SCAN_BASE64;

ALTER TABLE consent_template
DROP FOREIGN KEY FK_consent_template_SCAN_BASE64;

UPDATE scan
SET ID =
CASE
WHEN LOCATE('_###_CONSENTSCAN', ID) > 0 THEN SUBSTRING(ID, 1, LOCATE('_###_CONSENTSCAN', ID) - 1)
WHEN LOCATE('_###_CONSENTTEMPLATESCAN', ID) > 0 THEN SUBSTRING(ID, 1, LOCATE('_###_CONSENTTEMPLATESCAN', ID) - 1)
ELSE ID
END;

UPDATE consent
SET SCAN_BASE64 =
CASE
WHEN LOCATE('_###_CONSENTSCAN', SCAN_BASE64) > 0 THEN SUBSTRING(SCAN_BASE64, 1, LOCATE('_###_CONSENTSCAN', SCAN_BASE64) - 1)
WHEN LOCATE('_###_CONSENTTEMPLATESCAN', SCAN_BASE64) > 0 THEN SUBSTRING(SCAN_BASE64, 1, LOCATE('_###_CONSENTTEMPLATESCAN', SCAN_BASE64) - 1)
ELSE SCAN_BASE64
END;

UPDATE consent_template
SET SCAN_BASE64 =
CASE
WHEN LOCATE('_###_CONSENTSCAN', SCAN_BASE64) > 0 THEN SUBSTRING(SCAN_BASE64, 1, LOCATE('_###_CONSENTSCAN', SCAN_BASE64) - 1)
WHEN LOCATE('_###_CONSENTTEMPLATESCAN', SCAN_BASE64) > 0 THEN SUBSTRING(SCAN_BASE64, 1, LOCATE('_###_CONSENTTEMPLATESCAN', SCAN_BASE64) - 1)
ELSE SCAN_BASE64
END;

ALTER TABLE consent
ADD CONSTRAINT FK_consent_SCAN_BASE64
FOREIGN KEY (SCAN_BASE64)
REFERENCES scan(ID);

ALTER TABLE consent_template
ADD CONSTRAINT FK_consent_template_SCAN_BASE64
FOREIGN KEY (SCAN_BASE64)
REFERENCES scan(ID);
-- end remove unused suffixes

ALTER TABLE `domain`
    CHANGE COLUMN `properties` `properties` VARCHAR(4095) DEFAULT NULL;

-- QC
CREATE TABLE `qc` (
	`COMMENT` VARCHAR(4095) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
	`TIMESTAMP` TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	`EXTERN_PROPERTIES` VARCHAR(4095) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
	`INSPECTOR` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
	`VIRTUAL_PERSON_ID` BIGINT(20) NOT NULL,
	`TYPE` VARCHAR(100) NOT NULL COLLATE 'utf8_general_ci',
	`CT_VERSION` INT(11) NOT NULL,
	`CT_DOMAIN_NAME` VARCHAR(50) NOT NULL COLLATE 'utf8_general_ci',
	`CONSENT_DATE` TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	`CT_NAME` VARCHAR(100) NOT NULL COLLATE 'utf8_general_ci',
	PRIMARY KEY (`CONSENT_DATE`, `VIRTUAL_PERSON_ID`, `CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`) USING BTREE,
	INDEX `I_qc_CONSENT_DATE` (`CONSENT_DATE`, `VIRTUAL_PERSON_ID`, `CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`) USING BTREE
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
;

ALTER TABLE qc
ADD CONSTRAINT FK_qc_CONSENT_DATE
FOREIGN KEY
(
  CONSENT_DATE,
  VIRTUAL_PERSON_ID,
  CT_DOMAIN_NAME,
  CT_NAME,
  CT_VERSION
)
REFERENCES consent
(
  CONSENT_DATE,
  VIRTUAL_PERSON_ID,
  CT_DOMAIN_NAME,
  CT_NAME,
  CT_VERSION
)  ON UPDATE CASCADE ON DELETE CASCADE
;

CREATE TABLE `qc_hist` (
	`COMMENT` VARCHAR(4095) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
	`TIMESTAMP` TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	`EXTERN_PROPERTIES` VARCHAR(4095) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
	`INSPECTOR` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
	`VIRTUAL_PERSON_ID` BIGINT(20) NOT NULL,
	`TYPE` VARCHAR(100) NOT NULL COLLATE 'utf8_general_ci',
	`CT_VERSION` INT(11) NOT NULL,
	`CT_DOMAIN_NAME` VARCHAR(50) NOT NULL COLLATE 'utf8_general_ci',
	`CONSENT_DATE` TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	`CT_NAME` VARCHAR(100) NOT NULL COLLATE 'utf8_general_ci',
	`START_DATE` TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
	`END_DATE` TIMESTAMP(3) NULL DEFAULT NULL,
	PRIMARY KEY (`CONSENT_DATE`, `VIRTUAL_PERSON_ID`, `CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`, `START_DATE`) USING BTREE,
	INDEX `I_qc_CONSENT_DATE` (`CONSENT_DATE`, `VIRTUAL_PERSON_ID`, `CT_DOMAIN_NAME`, `CT_NAME`, `CT_VERSION`) USING BTREE
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
;

ALTER TABLE qc_hist
ADD CONSTRAINT FK_qc_hist_CONSENT_DATE
FOREIGN KEY
(
  CONSENT_DATE,
  VIRTUAL_PERSON_ID,
  CT_DOMAIN_NAME,
  CT_NAME,
  CT_VERSION
)
REFERENCES consent
(
  CONSENT_DATE,
  VIRTUAL_PERSON_ID,
  CT_DOMAIN_NAME,
  CT_NAME,
  CT_VERSION
)  ON UPDATE CASCADE ON DELETE CASCADE
;

UPDATE gics.domain domain
SET domain.properties = CONCAT(domain.properties,
CONCAT(CONCAT(';VALID_QC_TYPES=###_auto_generated_###,not_checked,checked_no_faults,checked_minor_faults;INVALID_QC_TYPES=checked_major_faults,invalidated;DEFAULT_QC_TYPE=', @default_qs_state), ';'))
WHERE domain.properties NOT LIKE '%QC_TYPES%';

INSERT INTO qc (CONSENT_DATE, VIRTUAL_PERSON_ID, CT_DOMAIN_NAME, CT_NAME, CT_VERSION, TIMESTAMP, TYPE, COMMENT)
SELECT CONSENT_DATE, VIRTUAL_PERSON_ID, CT_DOMAIN_NAME, CT_NAME, CT_VERSION, NOW(), @default_qs_state, 'initial qs entry gics version 2.12.0'
FROM consent;

INSERT INTO qc_hist (CONSENT_DATE, VIRTUAL_PERSON_ID, CT_DOMAIN_NAME, CT_NAME, CT_VERSION, TIMESTAMP, TYPE, COMMENT, START_DATE)
SELECT CONSENT_DATE, VIRTUAL_PERSON_ID, CT_DOMAIN_NAME, CT_NAME, CT_VERSION, NOW(), @default_qs_state, 'initial qs entry gics version 2.12.0', NOW()
FROM consent;

CREATE TABLE `alias` (
  `CREATE_TIMESTAMP` timestamp(3) NOT NULL,
  `ORIG_SI_VALUE` varchar(255) NOT NULL,
  `ORIG_SIT_DOMAIN_NAME` varchar(50) NOT NULL,
  `ORIG_SIT_NAME` varchar(100) NOT NULL,
  `ALIAS_SI_VALUE` varchar(255) NOT NULL,
  `ALIAS_SIT_DOMAIN_NAME` varchar(50) NOT NULL,
  `ALIAS_SIT_NAME` varchar(100) NOT NULL,
  `DEACTIVATE_TIMESTAMP` timestamp(3) NULL DEFAULT NULL,
  PRIMARY KEY (`CREATE_TIMESTAMP`,`ALIAS_SI_VALUE`,`ORIG_SI_VALUE`,`ALIAS_SIT_NAME`,`ALIAS_SIT_DOMAIN_NAME`,`ORIG_SIT_DOMAIN_NAME`,`ORIG_SIT_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE alias
ADD CONSTRAINT FK_ALIAS_SIGNER_ID
FOREIGN KEY
(
  ALIAS_SI_VALUE,
  ALIAS_SIT_DOMAIN_NAME,
  ALIAS_SIT_NAME
)
REFERENCES signer_id
(
  VALUE,
  SIT_DOMAIN_NAME,
  SIT_NAME
)
;
ALTER TABLE alias
ADD CONSTRAINT FK_ORIG_SIGNER_ID
FOREIGN KEY
(
  ORIG_SI_VALUE,
  ORIG_SIT_DOMAIN_NAME,
  ORIG_SIT_NAME
)
REFERENCES signer_id
(
  VALUE,
  SIT_DOMAIN_NAME,
  SIT_NAME
)
;

CREATE TABLE healthcheck
(
   NAME VARCHAR(16) PRIMARY KEY NOT NULL
);

INSERT INTO healthcheck VALUES ('healthcheck');

ALTER TABLE module CHANGE COLUMN extern_properties extern_properties VARCHAR(4095) DEFAULT NULL;

ALTER TABLE module_consent_template CHANGE COLUMN extern_properties extern_properties VARCHAR(4095) DEFAULT NULL;

ALTER TABLE consent_template CHANGE COLUMN extern_properties extern_properties VARCHAR(4095) DEFAULT NULL;

ALTER TABLE domain CHANGE COLUMN extern_properties extern_properties VARCHAR(4095) DEFAULT NULL;

ALTER TABLE consent CHANGE COLUMN extern_properties extern_properties VARCHAR(4095) DEFAULT NULL;



