# HowTo: JMeter-Test mit Client-Zertifikat Übermittlung

### **Voraussetzung**
Client-Zertifikat im p12-Format

### **Schritt 1**
Client-Zertifikat gut erreichbar ablegen. Beispielsweise `apache-jmeter-5.0/bin/cert/<NAME_OF_CERTIFICATE>.p12`

### **Schritt 2**
Client-Zertifikat als nächstes in den Java-KeyStore aufnehmen. Hierzu folgenden Befehl ausführen (Pfad zum keytool ggf. anpassen. Bsp.: `C:\Program Files\Java\jdk-11.0.10\bin`):

`<PATH_TO_KEYTOOL>\keytool -importkeystore -srckeystore <NAME_OF_CERTIFICATE>.p12 -srcstoretype PKCS12 -srcstorepass <CLIENT-CERTIFICATE_PASSWORD> -keystore <NAME_OF_CERTIFICATE>.jks -storepass <PASSWORD_FOR_KEYSTORE>`

- `<CLIENT-CERTIFICATE_PASSWORD>` wurde bei der Erzeugung des Client-Zertifikates vergeben
- `<PASSWORD_FOR_KEYSTORE>` kann selbst gewählt werden und wird im nächsten Schritt benötigt

Es wurde eine `<NAME_OF_CERTIFICATE>.jks`

### **Schritt 3**
Anpassen der `system.properties` im bin-Ordner von jmeter (z. B. `apache-jmeter-5.0/bin/system.properties`)

Folgende Codezeilen anfügen:

```
# Bsp.: C:/Program Files/Java/jdk-11.0.10/bin
keytool.directory=<PATH_TO_KEYTOOL>

# Pfad zum Client-Zertifikat (Bsp.: C:/Dev/apache-jmeter-5.0/bin/cert/<NAME_OF_CERTIFICATE>.jks)
javax.net.ssl.keyStore=<PATH_TO_CERTIFICATE>/<NAME_OF_CERTIFICATE>.jks
javax.net.ssl.keyStorePassword=<PASSWORD_FOR_KEYSTORE>`
```

### **Abschluss**
Bei der Ausführung eines JMeter-Test wird das Client-Zertifikat automatisch übermittelt.